/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.converter.impl;

import com.ibm.icu.text.Normalizer;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import org.marc4j.converter.CharConverter;
import org.marc4j.converter.impl.AnselToUnicode;
import org.marc4j.converter.impl.ReverseCodeTable;
import org.marc4j.converter.impl.ReverseCodeTableHash;

public class UnicodeToAnsel
extends CharConverter {
    protected ReverseCodeTable rct;
    static final char ESC = '\u001b';
    static final char G0 = '(';
    static final char G0multibyte = '$';
    static final char G1 = ')';
    static final int ASCII = 66;

    public UnicodeToAnsel() {
        this.rct = this.loadGeneratedTable();
    }

    public UnicodeToAnsel(String pathname) {
        this.rct = new ReverseCodeTableHash(pathname);
    }

    public UnicodeToAnsel(InputStream in) {
        this.rct = new ReverseCodeTableHash(in);
    }

    private ReverseCodeTable loadGeneratedTable() {
        try {
            Class<?> generated = Class.forName("org.marc4j.converter.impl.ReverseCodeTableGenerated");
            Constructor<?> cons = generated.getConstructor(new Class[0]);
            Object rct = cons.newInstance(new Object[0]);
            return (ReverseCodeTable)rct;
        }
        catch (Exception e) {
            ReverseCodeTableHash rct = new ReverseCodeTableHash(AnselToUnicode.class.getResourceAsStream("resources/codetables.xml"));
            return rct;
        }
    }

    @Override
    public String convert(char[] data) {
        StringBuffer sb = new StringBuffer();
        this.rct.init();
        this.convertPortion(data, sb);
        if (this.rct.getPreviousG0() != 66) {
            sb.append('\u001b');
            sb.append('(');
            sb.append('B');
        }
        return sb.toString();
    }

    private void convertPortion(char[] data, StringBuffer sb) {
        for (int i = 0; i < data.length; ++i) {
            Character c = new Character(data[i]);
            StringBuffer marc = new StringBuffer();
            char charValue = c.charValue();
            if (charValue == ' ' && this.rct.getPreviousG0() != 49) {
                if (this.rct.getPreviousG0() == 49) {
                    sb.append('\u001b');
                    sb.append('(');
                    sb.append('B');
                    this.rct.setPreviousG0(66);
                }
                marc.append(" ");
            } else {
                if (!this.rct.charHasMatch(c)) {
                    String tmpNormed;
                    String tmpnorm = c.toString();
                    if (!tmpnorm.equals(tmpNormed = Normalizer.normalize((String)tmpnorm, (Normalizer.Mode)Normalizer.NFD))) {
                        this.convertPortion(tmpNormed.toCharArray(), sb);
                        continue;
                    }
                    if (this.rct.getPreviousG0() != 66) {
                        sb.append('\u001b');
                        sb.append('(');
                        sb.append('B');
                        this.rct.setPreviousG0(66);
                    }
                    sb.append("&#x" + Integer.toHexString(charValue).toUpperCase() + ";");
                    continue;
                }
                if (this.rct.inPreviousG0CharEntry(c)) {
                    marc.append(this.rct.getCurrentG0CharEntry(c));
                } else if (this.rct.inPreviousG1CharEntry(c)) {
                    marc.append(this.rct.getCurrentG1CharEntry(c));
                } else {
                    int charset = this.rct.getBestCharSet(c);
                    char[] marc8 = this.rct.getCharEntry(c, charset);
                    if (marc8.length == 3) {
                        marc.append('\u001b');
                        marc.append('$');
                        this.rct.setPreviousG0(charset);
                    } else if (marc8[0] < '\u0080') {
                        marc.append('\u001b');
                        if (charset != 98 && charset != 112) {
                            marc.append('(');
                        }
                        this.rct.setPreviousG0(charset);
                    } else {
                        marc.append('\u001b');
                        marc.append(')');
                        this.rct.setPreviousG1(charset);
                    }
                    marc.append((char)charset);
                    marc.append(marc8);
                }
            }
            if (this.rct.isCombining(c) && sb.length() > 0) {
                sb.insert(sb.length() - 1, marc);
                continue;
            }
            sb.append(marc);
        }
    }
}

