/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.util;

import java.text.DecimalFormat;
import java.text.FieldPosition;

public class CustomDecimalFormat
extends DecimalFormat {
    static String formatString = "00000000000000000000";
    static String maxString = "99999999999999999999";
    public static final int REP_ALL_ZEROS = 0;
    public static final int REP_ALL_NINES = 1;
    public static final int REP_TRUNCATE = 2;
    int overflowRepresentation = 1;
    long maximumValue;

    public CustomDecimalFormat(int numberDigits) {
        super(formatString.substring(0, numberDigits));
        this.maximumValue = Long.parseLong(maxString.substring(0, numberDigits));
        this.overflowRepresentation = 1;
        this.setMaximumIntegerDigits(numberDigits);
    }

    public CustomDecimalFormat(int numberDigits, int overflowType) {
        super(formatString.substring(0, numberDigits));
        this.maximumValue = Long.parseLong(maxString.substring(0, numberDigits));
        this.overflowRepresentation = overflowType;
        this.setMaximumIntegerDigits(5);
    }

    @Override
    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        if (number > (double)this.maximumValue) {
            number = this.getOverflowRepresentation((long)number);
        }
        return super.format(number, toAppendTo, pos);
    }

    @Override
    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
        if (number > this.maximumValue) {
            number = this.getOverflowRepresentation(number);
        }
        return super.format(number, toAppendTo, pos);
    }

    private long getOverflowRepresentation(long number) {
        switch (this.overflowRepresentation) {
            case 0: {
                return 0L;
            }
            default: {
                return this.maximumValue;
            }
            case 2: 
        }
        return number % (this.maximumValue + 1L);
    }
}

