/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.util;

import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.marc4j.MarcStreamReader;
import org.marc4j.MarcXmlWriter;
import org.marc4j.converter.CharConverter;
import org.marc4j.converter.impl.AnselToUnicode;
import org.marc4j.converter.impl.Iso5426ToUnicode;
import org.marc4j.converter.impl.Iso6937ToUnicode;
import org.marc4j.marc.Record;

public class MarcXmlDriver {
    public static void main(String[] args) {
        long start = System.currentTimeMillis();
        String input = null;
        String output = null;
        String stylesheet = null;
        String convert = null;
        String encoding = "ISO_8859_1";
        boolean normalize = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-xsl")) {
                if (i == args.length - 1) {
                    MarcXmlDriver.usage();
                }
                stylesheet = args[++i].trim();
                continue;
            }
            if (args[i].equals("-out")) {
                if (i == args.length - 1) {
                    MarcXmlDriver.usage();
                }
                output = args[++i].trim();
                continue;
            }
            if (args[i].equals("-convert")) {
                if (i == args.length - 1) {
                    MarcXmlDriver.usage();
                }
                convert = args[++i].trim();
                continue;
            }
            if (args[i].equals("-encoding")) {
                if (i == args.length - 1) {
                    MarcXmlDriver.usage();
                }
                encoding = args[++i].trim();
                continue;
            }
            if (args[i].equals("-normalize")) {
                normalize = true;
                continue;
            }
            if (args[i].equals("-usage")) {
                MarcXmlDriver.usage();
                continue;
            }
            if (args[i].equals("-help")) {
                MarcXmlDriver.usage();
                continue;
            }
            input = args[i].trim();
            if (i == args.length - 1) continue;
            MarcXmlDriver.usage();
        }
        if (input == null) {
            MarcXmlDriver.usage();
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(input);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        MarcStreamReader reader = null;
        reader = encoding != null ? new MarcStreamReader(in, encoding) : new MarcStreamReader(in);
        OutputStream out = null;
        if (output != null) {
            try {
                out = new FileOutputStream(output);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            out = System.out;
        }
        MarcXmlWriter writer = null;
        if (stylesheet == null) {
            writer = convert != null ? new MarcXmlWriter(out, "UTF8") : new MarcXmlWriter(out, "UTF8");
        } else {
            Writer outputWriter = null;
            if (convert != null) {
                try {
                    outputWriter = new OutputStreamWriter(out, "UTF8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                outputWriter = new BufferedWriter(outputWriter);
            } else {
                outputWriter = new OutputStreamWriter(out);
                outputWriter = new BufferedWriter(outputWriter);
            }
            StreamResult result = new StreamResult(outputWriter);
            StreamSource source = new StreamSource(stylesheet);
            writer = new MarcXmlWriter((Result)result, source);
        }
        writer.setIndent(true);
        if (convert != null) {
            CharConverter charconv = null;
            if ("MARC8".equals(convert)) {
                charconv = new AnselToUnicode();
            } else if ("ISO5426".equals(convert)) {
                charconv = new Iso5426ToUnicode();
            } else if ("ISO6937".equals(convert)) {
                charconv = new Iso6937ToUnicode();
            } else {
                System.err.println("Unknown character set");
                System.exit(1);
            }
            writer.setConverter(charconv);
        }
        if (normalize) {
            writer.setUnicodeNormalization(true);
        }
        while (reader.hasNext()) {
            Record record = reader.next();
            if ("MARC8".equals(convert)) {
                record.getLeader().setCharCodingScheme('a');
            }
            writer.write(record);
        }
        writer.close();
        System.err.println("Total time: " + (System.currentTimeMillis() - start) + " miliseconds");
    }

    private static void usage() {
        System.err.println("MARC4J, Copyright (C) 2002-2006 Bas Peters");
        System.err.println("Usage: org.marc4j.util.MarcXmlDriver [-options] <file.mrc>");
        System.err.println("       -convert <encoding> = Converts <encoding> to UTF-8");
        System.err.println("       Valid encodings are: MARC8, ISO5426, ISO6937");
        System.err.println("       -normalize = perform Unicode normalization");
        System.err.println("       -xsl <file> = Post-process MARCXML using XSLT stylesheet <file>");
        System.err.println("       -out <file> = Output using <file>");
        System.err.println("       -usage or -help = this message");
        System.err.println("The program outputs well-formed MARCXML");
        System.err.println("See http://marc4j.tigris.org for more information.");
        System.exit(1);
    }
}

