(ns toxi.collections)

(defn successive-pairs
  "Returns a lazyseq of 2-element vectors, each one containing
  a pair of successive elements of the original collection.
  e.g. [1 2 3 4] -> ([1 2] [2 3] [3 4])"  
  [coll] (map (fn[p q] [p q]) (butlast coll) (drop 1 coll)))
