(ns toxi.geom.clip
  (:require
    [toxi.collections :as coll :only [successive-pairs]])
  (:use
    [toxi.geom.core]
    [toxi.geom.line2d]
    [toxi.geom.polygon2d])
  (:import
    [toxi.geom.types Polygon2D]))

(defn clip-convex
  [poly bounds]
  (let[verts (:vertices poly)
       verts (conj verts (first verts))
       bcentroid (centroid bounds)
       edge-clip-pos (fn[e p q] (:pos (intersect e (line2d p q))))]
    (loop[cedges (edges bounds) points verts clipped []]
      (if-let[clip-edge (first cedges)]
        (let[sign (classify-point clip-edge bcentroid)
             clipped (reduce
                       (fn[acc [p q]]
                         (if (= sign (classify-point clip-edge p))
                           (if (= sign (classify-point clip-edge q))
                             (conj acc q)
                             (conj acc (edge-clip-pos clip-edge p q)))
                           (if (= sign (classify-point clip-edge q))
                             (conj acc (edge-clip-pos clip-edge p q) q)
                             acc)))
                       [] (coll/successive-pairs points))
             numc (count clipped)
             clipped (if (and (pos? numc) (not= (first clipped) (last clipped)))
                       (conj clipped (first clipped))
                       clipped)]
          (recur (rest cedges) clipped points))
        (polygon2d (butlast points))))))
