(ns toxi.data.collections)

(defn successive-pairs
  "Returns a lazyseq of 2-element vectors, each one containing
  a pair of successive elements of the original collection.
  e.g. [1 2 3 4] -> ([1 2] [2 3] [3 4])"  
  ([coll] (successive-pairs (first coll) (rest coll)))
  ([p coll]
    (lazy-seq
      (if-not (nil? (seq coll))
        (cons [p (first coll)]
              (successive-pairs (first coll) (rest coll)))))))
              
(defn successive-pairs-indexed
  "Returns a lazyseq of 3-element vectors, each one containing
  a pair of successive elements of the original collection and
  an sequence index.
  e.g. [10 20 30 40] -> ([10 20 0] [20 30 1] [30 40 2])"  
  ([coll] (successive-pairs-indexed (first coll) (rest coll) 0))
  ([p coll idx]
    (lazy-seq
      (if-not (nil? (seq coll))
        (cons [p (first coll) idx]
              (successive-pairs-indexed (first coll) (rest coll) (inc idx)))))))

(defn apply-to-keys
  "Applies f with arg to all given keys in type."
  [type keys f arg]
  (reduce (fn[acc k] (assoc acc k (f (get type k) arg))) type keys))
