(ns toxi.color.utils)

(defn equal-xyz?
  [a b]
  (and
    (= ^Double (:r a) ^Double (:r b))
    (= ^Double (:g a) ^Double (:g b))
    (= ^Double (:b a) ^Double (:b b))))

(defn aset-rgb
  [buf idx c]
  (aset-float buf idx (:r c))
  (aset-float buf (inc idx) (:g c))
  (aset-float buf (+ 2 idx) (:b c)))
