(ns toxi.data.index)

(defn index-item
  [index item]
  (let[id (get (:index index) item)]
    (if (nil? id)
      (let[newid (count (:items index))
           newidx (assoc index :index (assoc (:index index) item newid))
           newidx (assoc newidx :items (conj (:items newidx) item))]
        [newidx newid])
      [index id])))

(defn make-index
  ([] {:index {} :items []})
  ([items]
    (reduce #(first (index-item %1 %2)) (make-index) items))
  ([index items] {:index index :items items}))


(defn unindex-item
  [index item]
  (let [id (get (:index index) item)]
    (if-not (nil? id)
        (let [newidx (dissoc (:index index) item)
              items (:items index)
              newitems (reduce conj (subvec items 0 id) (subvec items (inc id)))]
          (make-index newidx newitems))
        index)))

(defn reindex-item
  [index item newitem]
  (let [id (get (:index index) item)]
    (if-not (nil? id)
      (let [newidx (assoc (dissoc (:index index) item) newitem id)
            items (:items index)
            newitems (reduce conj (conj (subvec items 0 id) newitem) (subvec items (inc id)))]
        (make-index newidx newitems))
        index)))