(ns toxi.geom.clip
  (:require
    [toxi.data.collections :as coll :only [successive-pairs]]
    [toxi.geom.core :as geom])
  (:import
    [toxi.geom.types Polygon2D]))

(defn clip-convex
  [poly bounds]
  (let[verts (:vertices poly)
       verts (conj verts (first verts))
       bcentroid (geom/centroid bounds)
       edge-clip-pos (fn[e p q] (:pos (geom/intersect e (geom/line2d p q))))]
    (loop[cedges (geom/edges bounds) points verts clipped []]
      (if-let[clip-edge (first cedges)]
        (let[sign (geom/classify-point clip-edge bcentroid)
             clipped (reduce
                       (fn[acc [p q]]
                         (if (= sign (geom/classify-point clip-edge p))
                           (if (= sign (geom/classify-point clip-edge q))
                             (conj acc q)
                             (conj acc (edge-clip-pos clip-edge p q)))
                           (if (= sign (geom/classify-point clip-edge q))
                             (conj acc (edge-clip-pos clip-edge p q) q)
                             acc)))
                       [] (coll/successive-pairs points))
             numc (count clipped)
             clipped (if (and (pos? numc) (not= (first clipped) (last clipped)))
                       (conj clipped (first clipped))
                       clipped)]
          (recur (rest cedges) clipped points))
        (geom/polygon2d (butlast points))))))
