(ns toxi.macros)

(defmacro relate
  "First applies f to a and b and then relates the results with the given
predicate. If the result is truthy, returns a else b."
  {:added "0.1"}
  [f pred a b]
  `(let[a# ~a b# ~b]
    (if (~pred (~f a#) (~f b#)) a# b#)))

(defmacro bench
  ([num expr] `(bench ~num ~expr false))
  ([num expr verbose]
  `(loop [stats# [] i# 0]
     (if (= i# ~num)
       {:avg (/ (reduce + stats#) ~num)
        :min (reduce min stats#)
        :max (reduce max stats#)
        :median (nth (sort stats#) (int (/ ~num 2)))}
       (let [start# (. System (nanoTime))
             ret# ~expr
             taken# (* (double (- (. System (nanoTime)) start#)) 1e-6)]
         (if ~verbose (prn (str "Elapsed time: " taken# " msecs")))
         (recur (conj stats# taken#) (inc i#)))))))
