(ns open-scad.models.air-pot-mold
  (:use clojure.pprint shuriken.macro)
  (:refer-clojure :exclude [use import])
  (:require [clojure.java.io :refer [writer]]
            [clojure.walk :refer [postwalk]]
            [clojure.spec.alpha :as s]
            [threading.core :refer :all]
            [weaving.core :refer :all]
            [open-scad.core :refer :all]
            [shuriken.sequential :refer [forcat]]
            [shuriken.spec :refer [conform!]]
            [open-scad.libs.relativity :as r])
  (:import [java.io File]))


; (def size                 100)
; (def brick-width          size)
; (def brick-length         size)
; (def brick-height         30)
; (def wall-thickness       10)
; (def nwaves               2)
; (def wave-height          10)
; (def wave-thickness       10)
; (def wave-resolution      20)
; (def wave-offset-ratio    1/2)
; (def join-depth           5)
; (def tip-ratios           [1/5 1/2 1/6 1/12])
; (def tip-tolerance        3/100)
; (def hole-size            4)
; (def hole-offset-x        (* 1/6 brick-width))
; (def hole-offset-y        (* 1/6 brick-length))
; (def mouth-size           (* 1/6 (/ size nwaves)))
; (def mouth-depth          (min 5 wave-height))
; (def mouth-tolerance      10/100)
; (def wave-suport-radius   (min (* 1/5 (/ brick-width  nwaves 2))
;                                (* 1/5 (/ brick-length nwaves 2))
;                                (* 6/5 mouth-size)))
; (def max-paper-thickness  5)


; (def main-brick
;   (cube brick-width brick-length brick-height :center false :convexity 4))


; `(::dig-brick {:brick ma-brique})
; (defgeometry dig-brick [brick]
;   (let [[x y z] [(- (width  brick) (* 2 wall-thickness))
;                  (- (length brick) (* 2 wall-thickness))
;                  (* 2 (height brick))]
;         digger  (->> (cube x y z :center false)
;                      (translate [wall-thickness
;                                  wall-thickness
;                                  (/ (- (height brick) (* (height brick)
;                                                          (second tip-ratios)))
;                                     2)]))]
;     (difference brick digger)))

; (defmethod width  ::dig-brick [[_type {:keys [brick]}]]  (width  brick))
; (defmethod length ::dig-brick [[_type {:keys [brick]}]]  (length brick))
; (defmethod height ::dig-brick [[_type {:keys [brick]}]]  (height brick))

; (defn arc-formula [w h]
;   (+ (/ h 2) (/ (* w w) (* 8 h))))

; (defgeometry arc-section [w h z]
;   (let [r (arc-formula w h)
;         d (* 2 r)]
;     (->> (difference
;            (cylinder r z :center false)
;            (->> (cube (+ 2 d) (+ 2 d) (+ 2 z) :center false)
;                 (translate [-1 -1 -1])
;                 (translate [(- (+ r 1)) (- (+ r 1)) 0])
;                 (translate [(- h) 0 0])))
;          (translate [(- (- r h)) (/ w -2) 0]))))

; (defmethod radius ::arc-section [[_type {:keys [w h]}]]
;   (arc-formula w h))

; (defgeometry add-joins [brick w h z]
;   (let [arcs (fn [offset]
;                (let [arc (arc-section w h (+ offset z))]
;                  [(->> arc
;                        (translate [-0.01 0 0])
;                        (rotate [(° -90) 0 0]))
;                   (->> arc
;                        (translate [-0.01 0 0])
;                        (rotate [(° 90) 0 (° 90)])
;                        (translate [0 0 w]))]))
;         [arc1  arc2] (arcs 0)]
;     (-> brick
;         (union
;           (let [[a1 a2] (arcs h)]
;             (intersection (translate [size 0 0] a1)
;                           (translate [0 size 0] a2)))
;           (translate [size 0 0] arc1)
;           (translate [0 size 0] arc2))
;         (difference (resize [0 (+ z h 2) 0] arc1)
;                     (resize [(+ z h 2) 0 0] arc2)))))

; (defmethod width  ::add-joins [[_type {:keys [brick]}]]  (width  brick))
; (defmethod length ::add-joins [[_type {:keys [brick]}]]  (length brick))
; (defmethod height ::add-joins [[_type {:keys [brick]}]]  (height brick))

; (defgeometry plug-tip [w l z corner]
;   (let [carver-dims [(* 1.1 l) corner corner]
;         carver      #(anchored [0 0 0]
;                                (div carver-dims
;                                     (->> (box carver-dims)
;                                          (rotated %))))]
;     (difference
;       (box [w l z])
;       (div [w l z]
;            [(align [[0 -1 1] [0 -1 -1] [0 1 1] [0 1 -1]]
;                    (carver [45 0 0]))
;             (align [[1 0 1] [1 0 -1]]
;                    (carver [45 0 90]))
;             (align [[1 1 0] [1 -1 0]]
;                    (carver [45 90 90]))]))))

; (defmethod width  ::plug-tip [[_type {:keys [w]}]]  w)
; (defmethod length ::plug-tip [[_type {:keys [l]}]]  l)
; (defmethod height ::plug-tip [[_type {:keys [z]}]]  z)


; (defgeometry add-tips [brick]
;   (let [tip        (apply plug-tip (map #(* % size) tip-ratios))
;         dims       [(width brick) (length brick) (height brick)]
;         tip-dims   [(width tip)   (length tip)   (height tip)]]
;     (-> brick
;         (union      (div dims {:anchor [-1 -1 -1]}
;                          (rotated [[0 0 0] [0 0 90]]
;                                   (align [1 0 0] tip))))
;         (difference (div dims {:anchor [-1 -1 -1]}
;                          (rotated [[0 0 0] [0 0 90]]
;                                   (align [-1 0 0]
;                                          (div tip-dims
;                                               (align [(-ep 1) 0 0]
;                                                      (scaled (mapv #(+ % tip-tolerance)
;                                                                    [1 1 1])
;                                                              tip))))))))))

; (defmethod width  ::add-tips [[_type {:keys [brick]}]]  (width  brick))
; (defmethod length ::add-tips [[_type {:keys [brick]}]]  (length brick))
; (defmethod height ::add-tips [[_type {:keys [brick]}]]  (height brick))


; (let [radius  (* 1/2 hole-size)
;       cyc     (->> (cylinder radius (* 2 size) :center false)
;                    (rotate [(° -90) 0 0])
;                    (translate [radius 0 radius])
;                    (translate [0 -1 0]))
;       cycoff  (* 1/6 brick-height)
;       off  (* 2 (+ cycoff radius))]
;   (def lo-hole (translate [cycoff (* -1/2 size) cycoff] cyc))
;   (def hi-hole (->> lo-hole
;                    (rotate [0 0 (° 90)])
;                    (translate [size size (- brick-height off)])))
;   (def holes   (union lo-hole hi-hole)))

; (defgeometry add-brick-holes [brick]
;   (difference brick
;               holes
;               ;; holes on the tips
;               (translate [size 0 0]     lo-hole)
;               (translate [0 (- size) 0] hi-hole)))

; (defmethod width  ::add-brick-holes [[_type {:keys [brick]}]]  (width  brick))
; (defmethod length ::add-brick-holes [[_type {:keys [brick]}]]  (length brick))
; (defmethod height ::add-brick-holes [[_type {:keys [brick]}]]  (height brick))

; (defn wavepos [v w nwaves]
;   (let [factor      (/ (* 2 π nwaves) w)
;         center      (/ w 2)
;         centralwave (/  (* 2 π (Math/floor (/ nwaves 2)))  factor)
;         offset      (- center centralwave)]
;     (* (+ v offset) factor)))

; (defn write-wavegrid [grid]
;   (let [f (doto (File/createTempFile "wavefield" "dat")
;                 (.deleteOnExit))]
;     (with-open [writer (writer f)]
;       (binding [*out* writer]
;         (doseq [vs grid]
;           (doseq [v vs]
;             (print (str (double v) " ")))
;           (print \newline))))
;     f))

; (defn wavegrid [x y z nwaves resolution offset & {:keys [invert]}]
;   (let [[xwaves ywaves] (if (number? nwaves) [nwaves nwaves] nwaves)
;         xstep       (/ x resolution)
;         ystep       (/ y resolution)
;         zfactor     (* 1/2 z)
;         waveoff     (wavepos offset x xwaves)
;         sign        (if invert - +)
;         zi          (fn [xi yi]
;                       (sign
;                        (+ (Math/cos (- (wavepos xi x xwaves) (sign waveoff)))
;                           (Math/cos (- (wavepos yi y ywaves) waveoff)))))]
;     (for [xi (range 0 (+ x xstep) xstep)]
;       (for [yi (range 0 (+ y ystep) ystep)]
;         (* (zi xi yi) zfactor)))))

; (defgeometry wavefield [x y z nwaves resolution
;                         & {:keys [invert flat-bottom offset thickness]
;                            :or {invert      false
;                                 flat-bottom true
;                                 offset      0
;                                 thickness   wave-thickness}}]
;   (let [[xwaves ywaves] (if (number? nwaves) [nwaves nwaves] nwaves)
;         grid (->> (wavegrid x y z nwaves resolution offset :invert invert)
;                   (postwalk (when| coll? doall)))
;         f    (write-wavegrid grid)
;         surf (->> (surface (.getAbsolutePath f)
;                            :convexity (Math/round(* 1.5 (max xwaves ywaves)))
;                            :center false)
;                   (resize [x y])
;                   (translate [0 0 z]))
;         OFFSET (/ 1 nwaves)
;         [X Y Z NWAVES RESOLUTION] (map #(* % (+ 1 OFFSET))
;                                        [x y z nwaves resolution])]
;     (if flat-bottom
;       surf
;       (difference
;         (union surf (translate [0 0 (- z)] (cube x y z :center false)))
;         (translate [(* -1/2 OFFSET x) (* -1/2 OFFSET y) (- thickness)]
;                    (union
;                      (wavefield X Y z NWAVES RESOLUTION
;                                 :invert invert
;                                 :offset (+ (* -1/2 OFFSET x) offset))
;                      (translate [0 0 (- Z)]
;                                 (cube X Y Z :center false))))))))

; ;; TODO: move to threading
; ;; maybe rename as <- and <- as -<
; (defthreading rev :prefix [>- >>-]
;   ([expr]
;    (let [[arrow & [head & subforms]] expr
;          this-fletching (case &threading-variant  >- '>-rev  >> '>>-rev)]
;      `(~this-fletching ~head (~arrow ~@subforms))))
;   ([first-expr second-expr]
;    (let [[expr [arrow & subforms]] (case &threading-variant
;                                      >-  [first-expr  second-expr]
;                                      >>- [second-expr first-expr])]
;      `(~arrow ~expr ~@(reverse subforms)))))

; (defgeometry add-waves [brick & {:keys [invert]}]
;   (let [move       (if| (->| second :invert)
;                      (->| (|| rotate [0 (° 180) 0])
;                           (|| translate [size 0 0]))
;                      (|| translate [0 0 brick-height]))
;         offset     (* wave-offset-ratio (/ (width brick) nwaves))
;         field      (wavefield brick-width brick-length wave-height
;                               nwaves wave-resolution
;                               :invert invert
;                               :offset offset
;                               :flat-bottom false)
;         anti-field (->> (difference
;                           (cube brick-width brick-length (* 2 wave-height)
;                                 :center false)
;                           (wavefield brick-width brick-length wave-height
;                                      nwaves wave-resolution
;                                      :invert invert
;                                      :offset offset
;                                      :flat-bottom true)))
;         walls      (->> (box [brick-width wall-thickness (* 2 wave-height)])
;                         (anchored outward)
;                         (named "wall")
;                         (align [[1 -1 -1] [1 1 -1]])
;                         (rotated [[0 0 0] [0 0 90]]))]
;     (union brick
;            (->> (box [brick-width brick-length 1]
;                      (difference
;                        walls
;                        (->> (align [-1 -1 -1] anti-field)
;                             (scaled [(+ep 1) (+ep 1) (+ep 1)]))))
;                 (named "scaffold")
;                 (anchored [-1 -1 -1])
;                 (hide "scaffold")
;                 (>>- (-> (union (difference
;                                   field
;                                   (div [brick-width brick-length 1]
;                                        {:anchor [-1 -1 -1]}
;                                        (translate [0 0 (+ep (* -2 wave-height))]
;                                                   walls))))))
;                 move))))

; (defmethod width  ::add-waves [[_type {:keys [brick]}]]  (width  brick))
; (defmethod length ::add-waves [[_type {:keys [brick]}]]  (length brick))
; (defmethod height ::add-waves [[_type {:keys [brick]}]]  (height brick))

; ;; TODO: move to shuriken
; (defn ><   [a x b] (and (>  x a) (<  x b)))
; (defn >=<  [a x b] (and (>= x a) (<  x b)))
; (defn >=<= [a x b] (and (>= x a) (<= x b)))
; (defn ><=  [a x b] (and (>  x a) (<= x b)))

; (defn on-each-wave [invert mode object & [{:keys [xmin xmax ymin ymax]
;                                            :or   {xmin 0 xmax brick-width
;                                                   ymin 0 ymax brick-length}}]]
;   (let [xstep  (/ brick-width nwaves)
;         ystep  (/ brick-length nwaves)
;         offset (* wave-offset-ratio (/ brick-width nwaves))
;         sign   (if invert - +)
;         gen    (fn [xoff yoff]
;                  (apply union
;                         (forcat [x (range 0 brick-width xstep)]
;                           (for [y  (range 0 brick-length ystep)
;                                 :let [x (+ x xoff offset)
;                                       y (+ y yoff offset)]
;                                 :when (and (>< xmin x xmax) (>< ymin y ymax))]
;                             (translate [x y 0] object)))))
;         ups    (gen 0 0)
;         downs  (gen (/ xstep 2) (/ ystep 2))]
;     (case mode
;       :up      ups
;       :down    downs
;       :up-down (union ups downs))))

; (defgeometry add-wave-supports [brick & {:keys [invert]}]
;   (let [sup    #(cylinder wave-suport-radius % :center false)
;         limits {:xmin wall-thickness :xmax (- brick-width wall-thickness)
;                 :ymin wall-thickness :ymax (- brick-width wall-thickness)}
;         ups    (sup (+ brick-height    wave-height  (/ wave-thickness 2)))
;         downs  (sup (+ brick-height (- wave-height) (/ wave-thickness 2)))]
;     (union brick
;            (difference
;              (union (on-each-wave invert :up   (if invert downs ups)   limits)
;                     (on-each-wave invert :down (if invert ups   downs) limits))
;              brick))))

; (defn add-wave-holes [brick & {:keys [invert]}]
;   (let [depth (-> mouth-depth (when-not-> (<- invert) (+ max-paper-thickness)))
;         stick (->> (cylinder (* 1/2 mouth-size) depth :center false)
;                    (translate [0 0 (-> brick-height
;                                        (if-> (<- invert)
;                                          (+ (* -1/10 depth))
;                                          (+ (* 2 wave-height)
;                                             (- depth))))])
;                    (>>- (when-> (<- invert)
;                           (let-> [f (<- (- 1 mouth-tolerance))]
;                             (->> (scale [f f 0]))))))
;         op    (if invert union difference)]
;     (op brick (on-each-wave invert :up stick))))


; (defmethod width  ::brick-with-joints [[_type {:keys [brick]}]]  (width  brick))
; (defmethod length ::brick-with-joints [[_type {:keys [brick]}]]  (length brick))
; (defmethod height ::brick-with-joints [[_type {:keys [brick]}]]  (height brick))

; (defn add-neighbors [brick]
;   (union brick
;          (translate [size 0 0] brick)
;          (translate [0 size 0] brick)))

; (defn brick [& {:keys [invert]}]
;   (-> main-brick
;       dig-brick
;       add-tips
;       #_(add-waves         :invert invert)
;       #_(add-wave-supports :invert invert)
;       #_(add-wave-holes    :invert invert)
;       #_(add-joins brick-height join-depth size)
;       #_add-brick-holes
;       #_add-neighbors))

; (defn place-above [brick brick-above & {:keys [ratio] :or {ratio 1}}]
;   (union brick (->> (identity brick-above)
;                     (rotate [(° 180) 0 0])
;                     (translate [0
;                                 brick-length
;                                 (* ratio (+ brick-height
;                                             (* 2 wave-height)
;                                             (/ wave-thickness 2)
;                                             (* 2 wave-height)
;                                             1))]))))

; (defn place-aside [brick brick-aside]
;   (union brick (->> brick-aside
;                     (translate [(* 4/3 brick-length) 0 0]))))


; (def everything
;   (place-aside (brick) (brick :invert true)))

; ; (render everything)
; ; (render (let [center-cube 10
; ;               center-half (/ center-cube 2)
; ;               extcube 20
; ;               ext-half (/ extcube 2)]
; ;           (cube center-cube center-cube center-cube)
; ;           (translate [(+ center-half ext-half)
; ;                       center-half center-half]
; ;                      (cube extcube extcube extcube))))

; (defgeometry box [[x y z]]
;   (cube (* 10 x) y z))


; (def letruc
;   (box [10 10 10]))

; (render letruc)

(def ^:dynamic *position* [0 0 0])
(def ^:dynamic *size*     [1 1 1])

(defgeometry align [v & block]
  (apply bind* [(var *position*) (mapv #(+ %1 (* 1/2 %2 %3))
                                        *position* *size* v)]
         block))

(defgeometry div [v & block]
  (apply bind* [(var *size*) v]
         block))

(defgeometry box [[x y z] & block]
  (-> (cube x y z)
      (when-> (<- (seq block))
        (union (apply div [x y z] block))
        (when-> (<- (:align &opts))
          (->> (align (:align &opts)))))
      (->> (translate *position*))))

(defgeometry box (s/cat :opts  (s/? map?)
                        :args  (s/spec (s/cat :x number? :y number? :z number?))
                        :block (s/* any?))
  (-> (cube x y z)
      (when-> (<- (seq block))
        (union (apply div [x y z] block))
        (when-> (<- (:align &opts))
          (->> (align (:align &opts)))))
      (->> (translate *position*))))

; (println
;   "****>"
;   (conform! (s/cat :opts  (s/? map?)
;                  :v     (s/spec (s/cat :x number? :y number? :z number?))
;                  :block (s/* any?))
;           [{:x :y} [1 2 3] 'a]))

; (render (box {:align [-1 0 0]} [10 10 10]
;              (box [5 5 5])))

(render (box [5 5 5]))
(println "uyoi")
