(ns open-scad.models.led-holder
  (:refer-clojure :exclude [use import])
  (:require [threading.core :refer :all]
            [weaving.core :refer :all]
            [open-scad.core :refer :all]
            [open-scad.libs.threads :refer [metric-thread]]
            [open-scad.libs.clip :as clip]
            [open-scad.libs.dot-scad :refer [rounded-cube]]))


(def led-hole-size          8)
(def bar-diameter           9.8)
(def support-bar-length     100)
(def support-bar-diameter   10)
(def support-clip-height    5)
(def support-ring-diameter  5)
(def support-ring-thickness 2)
(def support-ring-height    2)
(def base-height            8)
(def base-screw-diameter    (* 7/10 led-hole-size))
(def base-screw-height      (- base-height 2))
(def base-screw-pitch       1.2)
(def screw-handle-width     30)
(def screw-handle-length    3)
(def screw-handle-height    3)
(def guard-height           2)
(def guard-diameter         12)
(def wire-width             5.8)
(def clips-height           10)
(def butterfly-screw-height (* 9/10 base-screw-height))

(def clip         (clip/clip bar-diameter clips-height))
(def wire-clip    (clip/clip wire-width   clips-height))
(def base         (cylinder (/ led-hole-size  2) base-height  :center false))
(def guard        (cylinder (/ guard-diameter 2) guard-height :center false))
(def base-clips   (->> clip
                       (union
                         (->> (bind [clip/*clip-opening-ratio* 1/2]
                                wire-clip)
                              (rotate [0 0 (° 180)])
                              (translate
                                [(- (/ (- 0 bar-diameter wire-width) 2)
                                    (* 2 (thickness clip)))
                                 0 0])))
                       (translate [0 0 (* 1/2 (height clip))])))
(def base         (difference
                    (union base guard)
                    (translate [0 0 -1]
                               (metric-thread
                                 (+ 1.1 base-screw-diameter)
                                 base-screw-pitch
                                 (+ 2 base-screw-height)
                                 :leadin 3 :internal true))
                    (->> base-clips
                         (rotate [(° 90) 0 0])
                         (translate [0
                                     (/ clips-height 2)
                                     (+ (/ bar-diameter 2)
                                        (thickness clip)
                                        base-height)]))))
(def butterfly   (->> (rounded-cube [screw-handle-width
                                     screw-handle-length
                                     screw-handle-height] 1)
                      (translate [(* -1/2 screw-handle-width)
                                  (* -1/2 screw-handle-length)
                                  (+ butterfly-screw-height guard-height)])
                      (union (metric-thread base-screw-diameter
                                            base-screw-pitch
                                            butterfly-screw-height
                                            :leadin 3)
                             (translate [0 0 butterfly-screw-height] guard))))


(def support-clip (•- (clip/clip bar-diameter support-clip-height)
                      (->> (rotate [0 (° -90) (° 90)])
                           (translate [0 0 (+ (/ (-• width) 2)
                                              support-bar-diameter)]))))
(def support-ring (->> (difference (cylinder support-ring-diameter
                                             support-ring-height)
                                   (cylinder (- support-ring-diameter
                                                support-ring-thickness)
                                             (+ep support-ring-height)))
                       (rotate [0 (° 90) 0])))
(def support-bar  (->> (cylinder (/ support-bar-diameter 2) support-bar-length)
                       (rotate [0 (° 90) 0])
                       (translate [0 0 (/ support-bar-diameter 2)])
                       (union support-clip
                              (translate [(/ (- support-bar-length
                                                support-ring-thickness)
                                             2)
                                          0
                                          (+ (/ support-ring-diameter 2)
                                             support-bar-diameter)]
                                         support-ring)
                              (translate [(- (/ (- support-bar-length
                                                   support-ring-thickness)
                                                2))
                                          0
                                          (+ (/ support-ring-diameter 2)
                                             support-bar-diameter)]
                                         support-ring))))
(render ($fn 100
             (->> (union (part :butterfly-clip
                               [(part :base base)
                                (->> (part :butterfly-screw butterfly)
                                     (rotate [0 (° 180) 0])
                                     (translate [25 0 (+ butterfly-screw-height
                                                         guard-height
                                                         screw-handle-height)]))
                                #_(->> (part :base-clips base-clips)
                                     (translate [-15 0 0]))])
                         (->> (part :support-bar support-bar)
                              (translate [0 20 0]))))))

