//-- Parametric star
//-- (c)  2010 Juan Gonzalez-Gomez (Obijuan) juan@iearobotics.com
//-- GPL license

//-- The 2*n points of an n-pointed star are calculated as follows:
//-- There are two circunferences:  the inner and outer.  Outer points are located
//-- at angles: 0, 360/n, 360*2/n and on the outer circunference
//-- The inner points have the same angular distance but they are 360/(2*n) rotated
//-- respect to the outers. They are located on the inner circunference

//--- INPUT PARAMETERS:
//--- n: Number of points
//--  h: Height
//-- ri: Inner radius
//-- ro: outer radius
module parametric_star(n=5, h=3, ri=15, re=30) {

  //-- Calculate and draw a 2D tip of the star
 //-- INPUT:
 //-- ntip: Number of the tip (from 0 to n-1)
  module tipstar(ntip) {
     i1 =  [ri*cos(-360*ntip/n+360/(n*2)), ri*sin(-360*ntip/n+360/(n*2))];
    e1 = [re*cos(-360*ntip/n), re*sin(-360*ntip/n)];
    i2 = [ri*cos(-360*(ntip+1)/n+360/(n*2)), ri*sin(-360*(ntip+1)/n+360/(n*2))];
    polygon([ i1, e1, i2]);
  }

  //-- Draw the 2D star and extrude

   //-- The star is the union of n 2D tips.
   //-- A inner cylinder is also needed for filling
   //-- A flat (2D) star is built. The it is extruded
    linear_extrude(height=h)
    union() {
      for (i=[0:n-1]) {
         tipstar(i);
      }
      rotate([0,0,360/(2*n)]) circle(r=ri+ri*0.01,$fn=n);
    }
}

