tileHeight =  2; // [2:20]
tileWidth = 100;  // [10:300]
border = 0; // [5]

module tri(width=tileWidth, height=tileHeight) {
  translate([tileWidth / 2, 0, 0])
    cylinder(r = tileWidth, h = tileHeight, $fn = 3);
}

module poly(width=tileWidth, height=tileHeight) {
  union() {
    translate([0, 0, 0]) {
      tri(width=width, height=height);
      mirror([1, 0, 0]) tri(width=width, height=height);
    }
  }
}

module borderedRhombus(width=tileWidth, height=tileHeight, border=border) {
  rotate([0, 00, 30]) difference() {
    resize([tileWidth, 0, 0], auto = true) poly(width=width, height=height);
    resize([tileWidth - 2 * border, 0, 0], auto = true)
      translate([0, 0, tileHeight - 1])  poly(width=width, height=height);
  }
}

module rhombus(width=tileWidth, height=tileHeight) {
  rotate([0, 00, 30]) poly(width=width, height=height);
}

module tile(width=tileWidth, height=tileHeight) {
  offset = sqrt(3) * tileWidth / 2;
  union() {
    color("LemonChiffon")                        translate([0, offset, 0])   poly(width=width, height=height);
    color("SandyBrown")    rotate([0, 0, 120])   translate([0, offset, 0])   poly(width=width, height=height);
    color("YellowGreen")   rotate([0, 0, 60])    translate([0, -offset, 0])  poly(width=width, height=height);
  }
