# How to contribute to threadlib

Thank for considering a contribution to threadlib! Any help is greatly
appreciated.


## Did you find an issue?

* Check whether your issue has already been reported by searching under
  [existing issues](https://github.com/adrianschlatter/threadlib/issues).

* If don't find an issue addressing the problem, open a new issue.

* Choose a meaningful title, describe clearly what you consider to be a
  problem.

* If possible, provide example code or other means to make it easy for a
  maintainer to reproduce your problem.


## Did you write a patch?

You already have a solution for an issue or a new feature? All the better! A
pull request ("PR") is what you want to do.

* Open a new [pull-request](https://github.com/adrianschlatter/threadlib/pulls)
  with your patch.

* Try to create PRs that address a specific issue/feature/topic.

* Avoid PRs containing an assortment of unrelated fixes and features. Better
  split it into separate PRs for each topic.

* Clean up your code before creating a pull request: Remove code that you have
  commented out for debugging, remove test code you have added, e.g., inside
  threadlib.scad.

* Make sure the PR's description clearly describes the problem and your solution.
  Include relevant issue numbers if appropriate.

* You increase the chances of quick acceptance of your PR significantly if you
  have taken measures to assure quality (such as writing and passing tests).


## You intend to contribute new threads?

That's what we need the most! This is how to do it:

* Find the specs (usually specified in a norm, sometimes published openly)

* Convert these specs for use in threadlib:

  * Find help on this topic in [Design of threadlib](docs/DesignOfThreadlib.md)
    and [Creating Thread Specs](docs/CreatingThreadSpecs.md)

  * Use existing threads as examples. You find them beneath design/

* When done, proceed with a pull request (see "Did you write a patch?" above)
  

## Final remarks

Currently, threadlib is maintained in the spare time of a single person having
a family and a job. If you do not get immediate feedback to your issue or pull
request, please have some patience.
