(ns open-scad.models.kossel-effector-screw-adapter
  (:require [open-scad.core :refer :all]))

(defgeometry original-effector []
  (->> (import "/Users/clement/Documents/Code/Clojure/open-scad/resources/effector.stl")
       (rotate [(° 180) 0 0])))

(defgeometry screw-adapter []
  (let [tri             (->> ($fn 3 (cylinder 18 3 :center false))
                             (rotate [0 0 1/2]))
        cyl             (->> (cylinder 2 3 :center false)
                             (translate [10 10 0]))
        screw-hole      (cylinder (/ 3.2 2) 20 :center true)
        screw-head-hole (cylinder (/ 6 2) 20 :center true)
        center-hole     (cylinder (/ 9.45 2) 20 :center true)]
    (-> (->> (minkowski cyl tri)
             (translate [-10 -10 0]))
        (difference [(->> screw-head-hole (translate [0 12 0]))
                     (->> screw-head-hole (translate [10 -5.75 0]))
                     (->> screw-head-hole (translate [-10 -6 0]))])
        (difference [(->> screw-hole (translate [0 -12.5 0]))
                     (->> screw-hole (translate [-10.75 6.25 0]))
                     (->> screw-hole (translate [10.75  6.25 0]))])
        (difference center-hole))))

; (render ($fn 40 [#_(original-effector)
;                  (screw-adapter)]))
