(ns open-scad.models.pen-holder
  (:use clojure.pprint)
  (:refer-clojure :exclude [use import])
  (:require [threading.core :refer :all]
            [weaving.core :refer :all]
            [open-scad.core :refer :all]
            [open-scad.libs.clip :refer :all]))

(def radiator-width  22.00)
(def radiator-height 25.75)
(def pen-width       10.00)
(def clip-height     (- (/ radiator-height 3) 2))

(def everything
  (let [radiator-clip (clip radiator-width clip-height :screw true)
        pen-clip      (clip pen-width      clip-height :screw true)]
    (union radiator-clip
           (->> pen-clip
                (rotate [0 0 (° 180)])
                (translate [(- (/ (+ (width pen-clip)
                                     (width radiator-clip))
                                  -2)
                               (- (thickness pen-clip)))
                            0 0])))))

(render ($fn 100 everything))
