/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.batch.impl.spring.admin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.trpr.platform.batch.common.JobHost;
import org.trpr.platform.batch.common.utils.ConfigFileUtils;
import org.trpr.platform.batch.spi.spring.admin.JobConfigurationService;
import org.trpr.platform.batch.spi.spring.admin.JobService;
import org.trpr.platform.batch.spi.spring.admin.SyncService;
import org.trpr.platform.core.PlatformException;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;
import org.trpr.platform.runtime.common.RuntimeVariables;
import org.trpr.platform.runtime.impl.config.FileLocator;

public class SimpleJobConfigurationService
implements JobConfigurationService {
    private Map<String, List<String>> jobDependencies;
    private Map<String, URI> jobXMLFile;
    private Map<String, List<JobHost>> jobHostNames;
    private List<JobHost> hostNames;
    private List<String> currentJobNames;
    private JobRegistry jobRegistry;
    private JobHost hostName;
    private SyncService syncService;
    private JobService jobService;
    private static final Logger LOGGER = LogFactory.getLogger(SimpleJobConfigurationService.class);
    private static final String SPRING_BATCH_FILE = "/spring-batch-config.xml";
    private static final String JOB_FOLDER = "/src/main/resources/external/";
    private static final String LIBRARY_FOLDER = "/lib/";
    private static final String SPRING_BATCH_PREV = "/spring-batch-config-prev.xml";

    public SimpleJobConfigurationService(JobRegistry jobRegistry, JobService jobService) {
        this.jobRegistry = jobRegistry;
        this.jobDependencies = new HashMap<String, List<String>>();
        this.jobXMLFile = new HashMap<String, URI>();
        this.jobHostNames = new HashMap<String, List<JobHost>>();
        this.hostNames = new LinkedList<JobHost>();
        this.currentJobNames = new LinkedList<String>();
        this.syncService = null;
        this.jobService = jobService;
    }

    @Override
    public SyncService getSyncService() {
        return this.syncService;
    }

    @Override
    public void setSyncService(SyncService syncService) {
        this.syncService = syncService;
    }

    @Override
    public void setPort(int port) {
        String hostName = "";
        String ipAddr = "";
        try {
            hostName = InetAddress.getLocalHost().getHostName();
            ipAddr = InetAddress.getLocalHost().getHostAddress();
            Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
            block3: while (nets.hasMoreElements()) {
                NetworkInterface netint = nets.nextElement();
                Enumeration<InetAddress> ips = netint.getInetAddresses();
                while (ips.hasMoreElements()) {
                    InetAddress ip = ips.nextElement();
                    if (ip.isLoopbackAddress() || !ip.isSiteLocalAddress()) continue;
                    LOGGER.info("Host IP Address: " + ip.getHostAddress());
                    ipAddr = ip.getHostAddress();
                    continue block3;
                }
            }
        }
        catch (UnknownHostException e) {
            LOGGER.error("Error while getting hostName ", (Throwable)e);
        }
        catch (SocketException e) {
            LOGGER.error("Error while getting hostName ", (Throwable)e);
        }
        this.hostName = new JobHost(hostName, ipAddr, port);
    }

    @Override
    public JobHost getCurrentHostName() {
        return this.hostName;
    }

    @Override
    public Collection<String> getCurrentHostJobs() {
        return this.currentJobNames;
    }

    @Override
    public void addJobInstance(String jobName, JobHost hostName) {
        LOGGER.info("hostName: " + hostName.getAddress() + " has job:" + jobName);
        if (this.jobHostNames.containsKey(jobName)) {
            if (!this.jobHostNames.get(jobName).contains(hostName)) {
                this.jobHostNames.get(jobName).add(hostName);
            }
        } else {
            LinkedList<JobHost> hostList = new LinkedList<JobHost>();
            hostList.add(hostName);
            this.jobHostNames.put(jobName, hostList);
        }
        if (!this.hostNames.contains(hostName)) {
            this.hostNames.add(hostName);
        }
        if (!this.currentJobNames.contains(jobName) && this.jobHostNames.get(jobName).contains(this.getCurrentHostName())) {
            this.currentJobNames.add(jobName);
        }
    }

    @Override
    public void clearJobInstances() {
        this.hostNames = new LinkedList<JobHost>();
        this.jobHostNames = new HashMap<String, List<JobHost>>();
    }

    @Override
    public List<JobHost> getHostNames(String jobName) {
        return this.jobHostNames.get(jobName);
    }

    @Override
    public List<JobHost> getAllHostNames() {
        return this.hostNames;
    }

    @Override
    public URI getJobStoreURI(String jobName) {
        String directoryPath;
        URI XMLFileURI = this.getJobConfigURI(jobName);
        if (XMLFileURI == null) {
            directoryPath = RuntimeVariables.getProjectsRoot() + JOB_FOLDER + jobName + "/";
        } else {
            String XMLFilePath = XMLFileURI.getPath();
            directoryPath = XMLFilePath.substring(0, XMLFilePath.lastIndexOf(47));
        }
        return new File(directoryPath).toURI();
    }

    @Override
    public void addJobDependency(List<String> jobNames, String destFileName, byte[] fileContents) {
        if (this.jobDependencies.isEmpty()) {
            this.scanJobDependencies();
        }
        if (jobNames == null || jobNames.size() == 0) {
            throw new PlatformException("No job names supplied");
        }
        for (String jobName : jobNames) {
            String destPath = this.getJobStoreURI(jobName).getPath();
            try {
                if (this.jobDependencies.containsKey(jobName) && this.jobDependencies.get(jobName).contains(destFileName)) {
                    LOGGER.info("Overwriting existing dependency file");
                }
                this.upload(fileContents, destPath + LIBRARY_FOLDER + destFileName);
            }
            catch (IOException e) {
                LOGGER.error("Error uploading file: " + destFileName + " to " + destPath);
                throw new PlatformException("Error uploading file: " + destFileName + " to " + destPath, (Throwable)e);
            }
            List<Object> dependencyList = null;
            if (this.jobDependencies.containsKey(jobName)) {
                dependencyList = this.jobDependencies.get(jobName);
            } else {
                dependencyList = new LinkedList();
                this.jobDependencies.put(jobName, dependencyList);
            }
            if (!dependencyList.contains(destFileName)) {
                dependencyList.add(destFileName);
            }
            this.jobDependencies.put(jobName, dependencyList);
        }
    }

    @Override
    public List<String> getJobDependencyList(String jobName) {
        if (this.jobDependencies.isEmpty()) {
            this.scanJobDependencies();
        }
        return this.jobDependencies.get(jobName);
    }

    @Override
    public Resource getJobConfig(String jobName) {
        if (this.getJobConfigURI(jobName) == null) {
            return null;
        }
        return new FileSystemResource(new File(this.getJobConfigURI(jobName)));
    }

    @Override
    public void setJobConfig(List<String> jobNames, Resource jobConfigFile) throws PlatformException {
        if (this.jobXMLFile.isEmpty()) {
            this.scanXMLFiles();
        }
        String destPath = null;
        try {
            HashSet<String> jobNamesUserSet = new HashSet<String>();
            HashSet<String> jobNamesFileSet = new HashSet<String>();
            jobNamesUserSet.addAll(jobNames);
            jobNamesFileSet.addAll(ConfigFileUtils.getJobName(jobConfigFile));
            if (!((Object)jobNamesUserSet).equals(jobNamesFileSet)) {
                throw new PlatformException("The Job Name cannot be changed. Expecting: " + ((Object)jobNamesUserSet).toString() + " Got: " + ((Object)jobNamesFileSet).toString());
            }
            String jobName = jobNames.get(0);
            if (this.getJobConfigURI(jobName) == null) {
                destPath = this.getJobStoreURI(jobName).getPath() + SPRING_BATCH_FILE;
            } else {
                destPath = this.getJobConfigURI(jobName).getPath();
                this.createPrevConfigFile(jobName);
            }
            this.upload(ConfigFileUtils.getContents(jobConfigFile).getBytes(), destPath);
            for (String allJobName : jobNames) {
                this.jobXMLFile.put(allJobName, new File(destPath).toURI());
            }
        }
        catch (IOException ioe) {
            LOGGER.error("Error creating job configuration file for : " + jobNames.toString() + " in location : " + destPath, (Throwable)ioe);
            throw new PlatformException("Error creating job configuration file for : " + jobNames.toString() + " in location : " + destPath, (Throwable)ioe);
        }
    }

    @Override
    public void deployJob(List<String> jobNames) {
        HashSet<URI> deployedJobConfigs = new HashSet<URI>();
        for (String jobName : jobNames) {
            try {
                if (deployedJobConfigs.contains(this.getJobConfig(jobName).getURI())) continue;
                LOGGER.info("The config file is: " + this.getJobConfig(jobName).getURI());
                this.jobService.getComponentContainer().loadComponent(this.getJobConfig(jobName));
                deployedJobConfigs.add(this.getJobConfig(jobName).getURI());
            }
            catch (Exception e) {
                this.restorePrevConfigFile(jobName);
                if (this.getJobConfig(jobName) != null) {
                    this.jobService.getComponentContainer().loadComponent(this.getJobConfig(jobName));
                }
                throw new PlatformException((Throwable)e);
            }
            this.removePrevConfigFile(jobName);
        }
    }

    private URI getJobConfigURI(String jobName) {
        if (this.jobXMLFile.isEmpty()) {
            this.scanXMLFiles();
        }
        if (this.jobXMLFile.containsKey(jobName)) {
            return this.jobXMLFile.get(jobName);
        }
        return null;
    }

    private void createPrevConfigFile(String jobName) {
        File configFile = new File(this.getJobConfigURI(jobName));
        File prevFile = new File(this.getJobStoreURI(jobName).getPath() + SPRING_BATCH_PREV);
        if (configFile.exists()) {
            if (prevFile.exists()) {
                prevFile.delete();
            }
            configFile.renameTo(prevFile);
            try {
                configFile.createNewFile();
            }
            catch (IOException e) {
                LOGGER.error("IOException while clearing config File", (Throwable)e);
            }
            prevFile.deleteOnExit();
        }
    }

    private void removePrevConfigFile(String jobName) {
        String prevFilePath = this.getJobStoreURI(jobName).getPath() + SPRING_BATCH_PREV;
        File prevFile = new File(prevFilePath);
        if (prevFile.exists()) {
            prevFile.delete();
        }
    }

    private void restorePrevConfigFile(String jobName) {
        File prevFile;
        File configFile = new File(this.getJobConfigURI(jobName));
        if (configFile.exists()) {
            configFile.delete();
        }
        if ((prevFile = new File(this.getJobStoreURI(jobName).getPath() + SPRING_BATCH_PREV)).exists()) {
            prevFile.renameTo(configFile);
        } else {
            this.jobXMLFile.remove(jobName);
        }
    }

    private void scanJobDependencies() {
        for (String jobName : this.jobRegistry.getJobNames()) {
            String jobDirectory = this.getJobStoreURI(jobName).getPath() + LIBRARY_FOLDER;
            File folder = new File(jobDirectory);
            File[] listOfFiles = folder.listFiles();
            LinkedList<String> dependencyList = new LinkedList<String>();
            if (listOfFiles != null) {
                for (File dependency : listOfFiles) {
                    dependencyList.add(dependency.getName());
                }
            }
            this.jobDependencies.put(jobName, dependencyList);
        }
    }

    private void scanXMLFiles() {
        File[] jobBeansFiles;
        for (File jobBeansFile : jobBeansFiles = FileLocator.findFiles((String)"spring-batch-config.xml")) {
            for (String jobName : ConfigFileUtils.getJobName((Resource)new FileSystemResource(jobBeansFile))) {
                this.jobXMLFile.put(jobName, jobBeansFile.toURI());
            }
        }
    }

    private void upload(byte[] fileContents, String destPath) throws IOException {
        File destFile = new File(destPath);
        if (destFile.exists()) {
            destFile.delete();
            destFile.createNewFile();
        }
        destFile.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(destFile);
        fos.write(fileContents);
    }
}

