/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.batch.common;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.trpr.platform.batch.common.JobHost;

public class JobInfo
extends org.springframework.batch.admin.web.JobInfo {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("dd MMM yyyy hh:mm:ss zzz");
    private final String cronExpression;
    private final Date nextFireTime;
    private List<JobHost> hostNames;

    public JobInfo(String name, int executionCount, Long jobInstanceId, boolean launchable, boolean incrementable, String cronExpression, Date nextFireTime) {
        super(name, executionCount, jobInstanceId, launchable, incrementable);
        this.cronExpression = cronExpression;
        this.nextFireTime = nextFireTime;
        this.hostNames = new LinkedList<JobHost>();
    }

    public void addHost(JobHost hostName) {
        this.hostNames.add(hostName);
    }

    public void removeHost(JobHost hostName) {
        if (this.hostNames.contains(hostName)) {
            this.hostNames.remove(hostName);
        }
    }

    public List<JobHost> getHostNames() {
        return this.hostNames;
    }

    public String getcronExpression() {
        return this.cronExpression;
    }

    public String getnextFireTime() {
        if (this.nextFireTime == null) {
            return "not found";
        }
        return DATE_FORMAT.format(this.nextFireTime);
    }
}

