/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.batch.impl.spring.writer;

import java.util.List;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.trpr.platform.batch.spi.spring.writer.ItemAggregator;

public class CompositeItemWriter<T>
implements ItemWriter<T>,
InitializingBean {
    private List<ItemWriter<T>> delegates;
    private ItemAggregator<T> aggregator;

    public void write(List<? extends T> data) throws Exception {
        if (this.getAggregator() != null) {
            this.getAggregator().addData(data);
            while (this.getAggregator().hasNext()) {
                this.writeToOutput((List)this.getAggregator().next());
                this.getAggregator().remove();
            }
            return;
        }
        this.writeToOutput(data);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.delegates, (String)"The 'delegates' may not be null");
        Assert.notEmpty(this.delegates, (String)"The 'delegates' may not be empty");
    }

    public List<ItemWriter<T>> getDelegates() {
        return this.delegates;
    }

    public void setDelegates(List<ItemWriter<T>> delegates) {
        this.delegates = delegates;
    }

    public ItemAggregator<T> getAggregator() {
        return this.aggregator;
    }

    public void setAggregator(ItemAggregator<T> aggregator) {
        this.aggregator = aggregator;
    }

    protected void writeToOutput(List<? extends T> data) throws Exception {
        for (ItemWriter<T> writer : this.delegates) {
            writer.write(data);
        }
    }
}

