/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.batch.impl.spring.admin.repository;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.repository.dao.JobExecutionDao;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.util.Assert;

public class MapJobExecutionDao
implements JobExecutionDao {
    private final ConcurrentMap<Long, JobExecution> executionsById = new ConcurrentHashMap<Long, JobExecution>();
    private final AtomicLong currentId = new AtomicLong(0L);

    public void clear() {
        this.executionsById.clear();
    }

    private void addNewExecution(Long ID, JobExecution jobExecution) {
        this.executionsById.put(ID, jobExecution);
    }

    private static JobExecution copy(JobExecution original) {
        JobInstance jobInstance = original.getJobInstance();
        if (jobInstance == null) {
            JobExecution jobExecution = new JobExecution(original.getId());
        }
        JobExecution copy = new JobExecution(jobInstance, original.getId());
        if (original.getStartTime() != null) {
            copy.setStartTime((Date)original.getStartTime().clone());
        }
        if (original.getEndTime() != null) {
            copy.setEndTime((Date)original.getEndTime().clone());
        }
        if (original.getStatus() != null) {
            copy.setStatus(BatchStatus.valueOf((String)original.getStatus().name()));
        }
        if (original.getExitStatus() != null) {
            copy.setExitStatus(new ExitStatus(original.getExitStatus().getExitCode(), original.getExitStatus().getExitDescription()));
        }
        if (original.getCreateTime() != null) {
            copy.setCreateTime((Date)original.getCreateTime().clone());
        }
        if (original.getLastUpdated() != null) {
            copy.setLastUpdated((Date)original.getLastUpdated().clone());
        }
        copy.setVersion(original.getVersion());
        return copy;
    }

    public void saveJobExecution(JobExecution jobExecution) {
        Assert.isTrue((jobExecution.getId() == null ? 1 : 0) != 0);
        Long newId = this.currentId.getAndIncrement();
        jobExecution.setId(newId);
        jobExecution.incrementVersion();
        this.addNewExecution(newId, MapJobExecutionDao.copy(jobExecution));
    }

    public List<JobExecution> findJobExecutions(JobInstance jobInstance) {
        ArrayList<JobExecution> executions = new ArrayList<JobExecution>();
        for (JobExecution exec : this.executionsById.values()) {
            if (!exec.getJobInstance().equals((Object)jobInstance)) continue;
            executions.add(MapJobExecutionDao.copy(exec));
        }
        Collections.sort(executions, new Comparator<JobExecution>(){

            @Override
            public int compare(JobExecution e1, JobExecution e2) {
                long result = e1.getId() - e2.getId();
                if (result > 0L) {
                    return -1;
                }
                if (result < 0L) {
                    return 1;
                }
                return 0;
            }
        });
        return executions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateJobExecution(JobExecution jobExecution) {
        Long id = jobExecution.getId();
        Assert.notNull((Object)id, (String)"JobExecution is expected to have an id (should be saved already)");
        JobExecution persistedExecution = (JobExecution)this.executionsById.get(id);
        Assert.notNull((Object)persistedExecution, (String)"JobExecution must already be saved");
        JobExecution jobExecution2 = jobExecution;
        synchronized (jobExecution2) {
            if (!persistedExecution.getVersion().equals(jobExecution.getVersion())) {
                throw new OptimisticLockingFailureException("Attempt to update step execution id=" + id + " with wrong version (" + jobExecution.getVersion() + "), where current version is " + persistedExecution.getVersion());
            }
            jobExecution.incrementVersion();
            this.addNewExecution(id, MapJobExecutionDao.copy(jobExecution));
        }
    }

    public JobExecution getLastJobExecution(JobInstance jobInstance) {
        JobExecution lastExec = null;
        for (JobExecution exec : this.executionsById.values()) {
            if (!exec.getJobInstance().equals((Object)jobInstance)) continue;
            if (lastExec == null) {
                lastExec = exec;
            }
            if (!lastExec.getCreateTime().before(exec.getCreateTime())) continue;
            lastExec = exec;
        }
        return MapJobExecutionDao.copy(lastExec);
    }

    public Set<JobExecution> findRunningJobExecutions(String jobName) {
        HashSet<JobExecution> result = new HashSet<JobExecution>();
        for (JobExecution exec : this.executionsById.values()) {
            if (!exec.getJobInstance().getJobName().equals(jobName) || !exec.isRunning()) continue;
            result.add(MapJobExecutionDao.copy(exec));
        }
        return result;
    }

    public JobExecution getJobExecution(Long executionId) {
        return MapJobExecutionDao.copy((JobExecution)this.executionsById.get(executionId));
    }

    public void synchronizeStatus(JobExecution jobExecution) {
        JobExecution saved = this.getJobExecution(jobExecution.getId());
        if (saved.getVersion().intValue() != jobExecution.getVersion().intValue()) {
            jobExecution.upgradeStatus(saved.getStatus());
            jobExecution.setVersion(saved.getVersion());
        }
    }

    public void removeExecution(Long ID) {
        this.executionsById.remove(ID);
    }
}

