/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.batch.impl.spring;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;
import java.util.List;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.trpr.platform.batch.impl.spring.BatchConfigInfo;
import org.trpr.platform.batch.spi.spring.admin.JobService;
import org.trpr.platform.core.PlatformException;
import org.trpr.platform.core.spi.event.PlatformEventProducer;
import org.trpr.platform.model.event.PlatformEvent;
import org.trpr.platform.runtime.common.RuntimeVariables;
import org.trpr.platform.runtime.impl.bootstrapext.spring.ApplicationContextFactory;
import org.trpr.platform.runtime.impl.config.FileLocator;
import org.trpr.platform.runtime.spi.bootstrapext.BootstrapExtension;
import org.trpr.platform.runtime.spi.component.ComponentContainer;

public class SpringBatchComponentContainer
implements ComponentContainer {
    private static final String DEFAULT_EVENT_PRODUCER = "platformEventProducer";
    private static AbstractApplicationContext commonBatchBeansContext;
    private List<BatchConfigInfo> jobsContextList = new LinkedList<BatchConfigInfo>();
    private BootstrapExtension[] loadedBootstrapExtensions;
    private ClassLoader tccl;

    public static AbstractApplicationContext getCommonBatchBeansContext() {
        return commonBatchBeansContext;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public void setLoadedBootstrapExtensions(BootstrapExtension ... bootstrapExtensions) {
        this.loadedBootstrapExtensions = bootstrapExtensions;
    }

    public void init() throws PlatformException {
        File[] jobBeansFiles;
        this.tccl = Thread.currentThread().getContextClassLoader();
        ApplicationContextFactory defaultCtxFactory = null;
        BootstrapExtension[] bootstrapExtensionArray = this.loadedBootstrapExtensions;
        int n = this.loadedBootstrapExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            BootstrapExtension be = bootstrapExtensionArray[n2];
            if (ApplicationContextFactory.class.isAssignableFrom(be.getClass())) {
                defaultCtxFactory = (ApplicationContextFactory)be;
                break;
            }
            ++n2;
        }
        commonBatchBeansContext = new ClassPathXmlApplicationContext(new String[]{"packaged/common-batch-config.xml"}, (ApplicationContext)defaultCtxFactory.getCommonBeansContext());
        ((JobService)commonBatchBeansContext.getBean("jobService")).setComponentContainer(this);
        this.jobsContextList.add(new BatchConfigInfo(new File("packaged/common-batch-config.xml"), null, commonBatchBeansContext));
        if (RuntimeVariables.getRuntimeNature().equalsIgnoreCase("SERVER")) {
            commonBatchBeansContext = new ClassPathXmlApplicationContext(new String[]{"packaged/common-batch-server-nature-config.xml"}, (ApplicationContext)commonBatchBeansContext);
            this.jobsContextList.add(new BatchConfigInfo(new File("packaged/common-batch-server-nature-config.xml"), null, commonBatchBeansContext));
        }
        File[] fileArray = jobBeansFiles = FileLocator.findFiles((String)"spring-batch-config.xml");
        int n3 = jobBeansFiles.length;
        n = 0;
        while (n < n3) {
            File jobBeansFile = fileArray[n];
            BatchConfigInfo jobConfigInfo = new BatchConfigInfo(jobBeansFile);
            this.loadJobContext(jobConfigInfo);
            ++n;
        }
    }

    public void destroy() throws PlatformException {
        for (BatchConfigInfo batchConfigInfo : this.jobsContextList) {
            batchConfigInfo.getJobContext().close();
        }
        this.jobsContextList = null;
    }

    public void publishEvent(PlatformEvent event) {
        PlatformEventProducer publisher = (PlatformEventProducer)commonBatchBeansContext.getBean(DEFAULT_EVENT_PRODUCER);
        publisher.publishEvent(event);
    }

    public void publishBootstrapEvent(PlatformEvent bootstrapEvent) {
        this.publishEvent(bootstrapEvent);
    }

    public void loadComponent(Resource resource) {
        if (!FileSystemResource.class.isAssignableFrom(resource.getClass()) || !((FileSystemResource)resource).getFilename().equalsIgnoreCase("spring-batch-config.xml")) {
            throw new UnsupportedOperationException("Batch jobs can be loaded only from files by name : spring-batch-config.xml. Specified resource is : " + resource.toString());
        }
        this.loadJobContext(new BatchConfigInfo(((FileSystemResource)resource).getFile()));
    }

    private void loadJobContext(BatchConfigInfo batchConfigInfo) {
        for (BatchConfigInfo loadedJobInfo : this.jobsContextList) {
            if (!loadedJobInfo.equals(batchConfigInfo)) continue;
            batchConfigInfo = loadedJobInfo;
            break;
        }
        if (batchConfigInfo.getJobContext() != null) {
            batchConfigInfo.getJobContext().close();
            this.jobsContextList.remove(batchConfigInfo);
        }
        ClassLoader jobCL = this.tccl;
        File customLibPath = new File(batchConfigInfo.getJobConfigXML().getParentFile(), "lib");
        if (customLibPath.exists() && customLibPath.isDirectory()) {
            try {
                File[] libFiles = customLibPath.listFiles();
                URL[] libURLs = new URL[libFiles.length];
                int i = 0;
                while (i < libFiles.length) {
                    libURLs[i] = new URL("file:" + libFiles[i].getAbsolutePath());
                    ++i;
                }
                jobCL = new URLClassLoader(libURLs, this.tccl);
            }
            catch (MalformedURLException e) {
                throw new PlatformException((Throwable)e);
            }
        }
        batchConfigInfo.loadJobContext(jobCL);
        this.jobsContextList.add(batchConfigInfo);
    }
}

