/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.batch.impl.spring.reader;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.ParseException;
import org.springframework.batch.item.UnexpectedInputException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.trpr.platform.batch.spi.spring.reader.BatchItemStreamReader;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class CompositeItemStreamReader<T>
implements BatchItemStreamReader<T>,
InitializingBean {
    private static final int DEFAULT_BATCH_READ_TIMEOUT = 60;
    private static final Logger LOGGER = LogFactory.getLogger(CompositeItemStreamReader.class);
    private BatchItemStreamReader<T> delegate;
    private Queue<T> localQueue = new ConcurrentLinkedQueue<T>();
    private Queue<ExecutionContext> contextList = new ConcurrentLinkedQueue<ExecutionContext>();
    private CountDownLatch countDownLatch;
    private int batchReadTimeout = 60;

    public CompositeItemStreamReader(BatchItemStreamReader<T> delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T read() throws Exception, UnexpectedInputException, ParseException {
        CompositeItemStreamReader compositeItemStreamReader;
        block28: {
            CompositeItemStreamReader compositeItemStreamReader2 = this;
            synchronized (compositeItemStreamReader2) {
                if (!this.localQueue.isEmpty()) {
                    LOGGER.debug("Returning data from local cache. Cache size : " + this.localQueue.size());
                    return this.localQueue.poll();
                }
            }
            ExecutionContext context = null;
            compositeItemStreamReader = this;
            synchronized (compositeItemStreamReader) {
                if (!this.contextList.isEmpty()) {
                    context = this.contextList.poll();
                }
            }
            if (context != null) {
                LOGGER.debug("Invoking batch read on partition");
                try {
                    try {
                        T[] items = this.delegate.batchRead(context);
                        CompositeItemStreamReader compositeItemStreamReader3 = this;
                        synchronized (compositeItemStreamReader3) {
                            T[] TArray = items;
                            int n = items.length;
                            int n2 = 0;
                            while (n2 < n) {
                                T item = TArray[n2];
                                if (item != null) {
                                    this.localQueue.add(item);
                                }
                                ++n2;
                            }
                        }
                    }
                    catch (Exception exception) {
                        LOGGER.warn("Batch read failed for partition. Error is : {}", (Object)exception.getMessage(), (Object)exception);
                        this.countDownLatch.countDown();
                        if (!this.localQueue.isEmpty()) {
                            LOGGER.debug("Returning data from local cache after partition read. Cache size : " + this.localQueue.size());
                            return this.localQueue.poll();
                        }
                        break block28;
                    }
                }
                catch (Throwable throwable) {
                    this.countDownLatch.countDown();
                    if (!this.localQueue.isEmpty()) {
                        LOGGER.debug("Returning data from local cache after partition read. Cache size : " + this.localQueue.size());
                        return this.localQueue.poll();
                    }
                    throw throwable;
                }
                this.countDownLatch.countDown();
                if (!this.localQueue.isEmpty()) {
                    LOGGER.debug("Returning data from local cache after partition read. Cache size : " + this.localQueue.size());
                    return this.localQueue.poll();
                }
            }
        }
        this.countDownLatch.await(this.getBatchReadTimeout(), TimeUnit.SECONDS);
        if (this.countDownLatch.getCount() > 0L) {
            LOGGER.info("Count down latch timeout occurred before completion. Counting down to zero and clearing the context list!");
            this.contextList.clear();
            while (this.countDownLatch.getCount() > 0L) {
                this.countDownLatch.countDown();
            }
        }
        compositeItemStreamReader = this;
        synchronized (compositeItemStreamReader) {
            if (!this.localQueue.isEmpty()) {
                LOGGER.debug("Returning data from local cache after re-check. Cache size : " + this.localQueue.size());
                return this.localQueue.poll();
            }
        }
        LOGGER.debug("No more data to read. Returning null");
        return null;
    }

    @Override
    public T[] batchRead(ExecutionContext context) throws Exception, UnexpectedInputException, ParseException {
        throw new UnsupportedOperationException("Illegal invocation of batchRead(), call read() instead.");
    }

    public void close() throws ItemStreamException {
        this.delegate.close();
    }

    public void open(ExecutionContext context) throws ItemStreamException {
        LOGGER.debug("Called open for a partition");
        this.contextList.add(context);
        if (this.countDownLatch == null || this.countDownLatch.getCount() == 0L) {
            this.countDownLatch = new CountDownLatch(context.getInt("totalPartitions", 1));
        }
    }

    public void update(ExecutionContext context) throws ItemStreamException {
        this.delegate.update(context);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.delegate, (String)"The 'delegate' may not be null");
    }

    public BatchItemStreamReader<T> getDelegate() {
        return this.delegate;
    }

    public int getBatchReadTimeout() {
        return this.batchReadTimeout;
    }

    public void setBatchReadTimeout(int batchReadTimeout) {
        this.batchReadTimeout = batchReadTimeout;
    }
}

