/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.batch.impl.quartz;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.springframework.batch.core.job.flow.FlowJob;
import org.trpr.platform.batch.spi.quartz.ScheduleRepository;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class SimpleScheduleRepository
implements ScheduleRepository {
    private Map<String, Scheduler> jobSchedulers = new HashMap<String, Scheduler>();
    private static final Logger LOGGER = LogFactory.getLogger(SimpleScheduleRepository.class);

    @Override
    public String getCronExpression(String jobName) {
        Trigger trigger;
        String cronExpr = null;
        if (this.jobSchedulers.containsKey(jobName) && (trigger = this.getTriggerFromScheduler(jobName)) instanceof CronTrigger) {
            CronTrigger cronTrigger = (CronTrigger)trigger;
            cronExpr = cronTrigger.getCronExpression();
        }
        return cronExpr;
    }

    @Override
    public Date getNextFireDate(String jobName) {
        Date nextFireTime = null;
        if (this.jobSchedulers.containsKey(jobName)) {
            Trigger trigger = this.getTriggerFromScheduler(jobName);
            nextFireTime = trigger.getNextFireTime();
        }
        return nextFireTime;
    }

    @Override
    public boolean doesJobExists(String jobName) {
        return this.jobSchedulers.containsKey(jobName);
    }

    @Override
    public void addScheduler(String jobName, Scheduler scheduler) {
        this.jobSchedulers.put(jobName, scheduler);
    }

    @Override
    public Trigger getTriggerFromScheduler(String requiredJobName) {
        Scheduler sch = this.jobSchedulers.get(requiredJobName);
        try {
            String[] stringArray = sch.getJobGroupNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String groupName = stringArray[n2];
                String[] stringArray2 = sch.getJobNames(groupName);
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String jobName = stringArray2[n4];
                    Trigger[] triggers = sch.getTriggersOfJob(jobName, groupName);
                    JobDetail jd = sch.getJobDetail(jobName, groupName);
                    JobDataMap jdm = jd.getJobDataMap();
                    FlowJob fj = (FlowJob)jdm.get((Object)"jobName");
                    String fjName = fj.getName();
                    if (fjName.equals(requiredJobName)) {
                        return triggers[0];
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (SchedulerException e) {
            LOGGER.error("Error getting Trigger from scheduler", (Throwable)e);
        }
        return null;
    }

    @Override
    public Map<String, Scheduler> getJobSchedulers() {
        return this.jobSchedulers;
    }
}

