/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.batch.impl.spring.job;

import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class BatchJob
implements StatefulJob {
    private static final String TIMESTAMP = "TIMESTAMP";
    private static final Logger LOGGER = LogFactory.getLogger(BatchJob.class);
    public static final String JOB_NAME = "jobName";
    public static final String JOB_LAUNCHER = "jobLauncher";

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            JobParametersBuilder builder = new JobParametersBuilder();
            builder.addLong(TIMESTAMP, Long.valueOf(System.currentTimeMillis()));
            ((JobLauncher)context.getJobDetail().getJobDataMap().get((Object)JOB_LAUNCHER)).run((Job)context.getJobDetail().getJobDataMap().get((Object)JOB_NAME), builder.toJobParameters());
        }
        catch (JobExecutionAlreadyRunningException e) {
            LOGGER.error("Specified job is already running : " + (Object)((Object)e));
        }
        catch (JobRestartException e) {
            LOGGER.error("Unable to restart specified batch job : " + (Object)((Object)e));
        }
        catch (JobInstanceAlreadyCompleteException e) {
            LOGGER.error("Specified job is already complete : " + (Object)((Object)e));
        }
        catch (Exception e) {
            LOGGER.error("Job execution failed : " + e);
        }
    }
}

