/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.batch.impl.spring.admin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.springframework.batch.admin.service.NoSuchStepExecutionException;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobExecutionNotRunningException;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.core.launch.NoSuchJobExecutionException;
import org.springframework.batch.core.launch.NoSuchJobInstanceException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.batch.core.step.NoSuchStepException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.scheduling.annotation.Scheduled;
import org.trpr.platform.batch.spi.quartz.ScheduleRepository;
import org.trpr.platform.batch.spi.spring.admin.JobService;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;
import org.trpr.platform.runtime.spi.component.ComponentContainer;

public class SimpleJobService
implements JobService,
DisposableBean {
    private static final int DEFAULT_SHUTDOWN_TIMEOUT = 60000;
    private static final Logger LOGGER = LogFactory.getLogger(SimpleJobService.class);
    private int shutdownTimeout = 60000;
    private Collection<JobExecution> activeExecutions = Collections.synchronizedList(new ArrayList());
    private JobRepository jobRepository;
    private JobRegistry jobRegistry;
    private JobLauncher jobLauncher;
    private JobExplorer jobExplorer;
    private ScheduleRepository scheduleRepository;
    private ComponentContainer componentContainer;

    public SimpleJobService(JobRepository jobRepository, JobExplorer jobExplorer, JobRegistry jobRegistry, JobLauncher jobLauncher, ScheduleRepository scheduleRepository) {
        this.jobRepository = jobRepository;
        this.jobExplorer = jobExplorer;
        this.jobRegistry = jobRegistry;
        this.jobLauncher = jobLauncher;
        this.scheduleRepository = scheduleRepository;
    }

    public void destroy() throws Exception {
        Exception firstException = null;
        for (JobExecution jobExecution : this.activeExecutions) {
            try {
                if (!jobExecution.isRunning()) continue;
                this.stop(jobExecution.getId());
            }
            catch (JobExecutionNotRunningException e) {
                LOGGER.info("JobExecution is not running so it cannot be stopped");
            }
            catch (Exception e) {
                LOGGER.error("Unexpected exception stopping JobExecution", (Throwable)e);
                if (firstException != null) continue;
                firstException = e;
            }
        }
        int count = 0;
        int maxCount = (this.shutdownTimeout + 1000) / 1000;
        while (!this.activeExecutions.isEmpty() && ++count < maxCount) {
            LOGGER.error("Waiting for " + this.activeExecutions.size() + " active executions to complete");
            this.removeInactiveExecutions();
            Thread.sleep(1000L);
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    @Scheduled(fixedDelay=60000L)
    public void removeInactiveExecutions() {
        Iterator<JobExecution> iterator = this.activeExecutions.iterator();
        while (iterator.hasNext()) {
            JobExecution jobExecution = iterator.next();
            try {
                jobExecution = this.getJobExecution(jobExecution.getId());
            }
            catch (NoSuchJobExecutionException e) {
                LOGGER.error("Unexpected exception loading JobExecution", (Throwable)e);
            }
            if (jobExecution.isRunning()) continue;
            iterator.remove();
        }
    }

    public JobExecution abandon(Long jobExecutionId) throws NoSuchJobExecutionException, JobExecutionAlreadyRunningException {
        JobExecution jobExecution = this.getJobExecution(jobExecutionId);
        if (jobExecution.getStatus().isLessThan(BatchStatus.STOPPING)) {
            throw new JobExecutionAlreadyRunningException("JobExecution is running or complete and therefore cannot be aborted");
        }
        LOGGER.info("Aborting job execution: " + jobExecution);
        jobExecution.upgradeStatus(BatchStatus.ABANDONED);
        jobExecution.setEndTime(new Date());
        this.jobRepository.update(jobExecution);
        return jobExecution;
    }

    public int countJobExecutions() {
        int count = 0;
        for (String jobName : this.jobRegistry.getJobNames()) {
            for (JobInstance jobInstance : this.jobExplorer.getJobInstances(jobName, 0, Integer.MAX_VALUE)) {
                count += this.jobExplorer.getJobExecutions(jobInstance).size();
            }
        }
        return count;
    }

    public int countJobExecutionsForJob(String jobName) throws NoSuchJobException {
        int count = 0;
        for (String name : this.jobRegistry.getJobNames()) {
            if (!name.equalsIgnoreCase(jobName)) continue;
            for (JobInstance jobInstance : this.jobExplorer.getJobInstances(jobName, 0, Integer.MAX_VALUE)) {
                count += this.jobExplorer.getJobExecutions(jobInstance).size();
            }
        }
        return count;
    }

    public int countJobInstances(String jobName) throws NoSuchJobException {
        int count = 0;
        for (String name : this.jobRegistry.getJobNames()) {
            if (!name.equalsIgnoreCase(jobName)) continue;
            count += this.jobExplorer.getJobInstances(jobName, 0, Integer.MAX_VALUE).size();
            break;
        }
        return count;
    }

    public int countJobs() {
        return this.jobRegistry.getJobNames().size();
    }

    public int countStepExecutionsForStep(String jobName, String stepName) throws NoSuchStepException {
        int count = 0;
        for (String name : this.jobRegistry.getJobNames()) {
            if (!name.contains(jobName)) continue;
            for (JobInstance jobInstance : this.jobExplorer.getJobInstances(jobName, 0, Integer.MAX_VALUE)) {
                for (JobExecution jobExecution : this.jobExplorer.getJobExecutions(jobInstance)) {
                    Collection stepExecutions = jobExecution.getStepExecutions();
                    for (StepExecution step : stepExecutions) {
                        if (!step.getStepName().contains(stepName)) continue;
                        ++count;
                    }
                }
            }
        }
        return count;
    }

    public JobExecution getJobExecution(Long jobExecutionId) throws NoSuchJobExecutionException {
        for (String jobName : this.jobRegistry.getJobNames()) {
            for (JobInstance jobInstance : this.jobExplorer.getJobInstances(jobName, 0, Integer.MAX_VALUE)) {
                for (JobExecution jobExecution : this.jobExplorer.getJobExecutions(jobInstance)) {
                    if (jobExecution.getId().longValue() != jobExecutionId.longValue()) continue;
                    return jobExecution;
                }
            }
        }
        return null;
    }

    public Collection<JobExecution> getJobExecutionsForJobInstance(String jobName, Long jobInstanceId) throws NoSuchJobException {
        for (String name : this.jobRegistry.getJobNames()) {
            if (!name.contains(jobName)) continue;
            for (JobInstance jobInstance : this.jobExplorer.getJobInstances(jobName, 0, Integer.MAX_VALUE)) {
                if (jobInstance.getId().longValue() != jobInstanceId.longValue()) continue;
                return this.jobExplorer.getJobExecutions(jobInstance);
            }
        }
        return null;
    }

    public JobInstance getJobInstance(long jobInstanceId) throws NoSuchJobInstanceException {
        for (String jobName : this.jobRegistry.getJobNames()) {
            for (JobInstance jobInstance : this.jobExplorer.getJobInstances(jobName, 0, Integer.MAX_VALUE)) {
                if (jobInstance.getId() != jobInstanceId) continue;
                return jobInstance;
            }
        }
        return null;
    }

    public JobParameters getLastJobParameters(String jobName) throws NoSuchJobException {
        for (String name : this.jobRegistry.getJobNames()) {
            Iterator iterator;
            if (!name.contains(jobName) || !(iterator = this.jobExplorer.getJobInstances(jobName, 0, 1).iterator()).hasNext()) continue;
            JobInstance jobInstance = (JobInstance)iterator.next();
            return jobInstance.getJobParameters();
        }
        return null;
    }

    public StepExecution getStepExecution(Long jobExecutionId, Long stepExecutionId) throws NoSuchStepExecutionException, NoSuchJobExecutionException {
        for (String jobName : this.jobRegistry.getJobNames()) {
            for (JobInstance jobInstance : this.jobExplorer.getJobInstances(jobName, 0, Integer.MAX_VALUE)) {
                for (JobExecution jobExecution : this.jobExplorer.getJobExecutions(jobInstance)) {
                    if (jobExecution.getId().longValue() != jobExecutionId.longValue()) continue;
                    for (StepExecution step : jobExecution.getStepExecutions()) {
                        if (step.getId().longValue() != stepExecutionId.longValue()) continue;
                        return step;
                    }
                }
            }
        }
        return null;
    }

    public Collection<StepExecution> getStepExecutions(Long jobExecutionId) throws NoSuchJobExecutionException {
        for (String jobName : this.jobRegistry.getJobNames()) {
            for (JobInstance jobInstance : this.jobExplorer.getJobInstances(jobName, 0, Integer.MAX_VALUE)) {
                for (JobExecution jobExecution : this.jobExplorer.getJobExecutions(jobInstance)) {
                    if (jobExecution.getId().longValue() != jobExecutionId.longValue()) continue;
                    return jobExecution.getStepExecutions();
                }
            }
        }
        return null;
    }

    public Collection<String> getStepNamesForJob(String jobName) throws NoSuchJobException {
        LinkedHashSet<String> stepNames = new LinkedHashSet<String>();
        for (JobExecution jobExecution : this.listJobExecutionsForJob(jobName, 0, 100)) {
            for (StepExecution stepExecution : jobExecution.getStepExecutions()) {
                stepNames.add(stepExecution.getStepName());
            }
        }
        return Collections.unmodifiableList(new ArrayList(stepNames));
    }

    public boolean isIncrementable(String jobName) {
        try {
            return this.jobRegistry.getJobNames().contains(jobName) && this.jobRegistry.getJob(jobName).getJobParametersIncrementer() != null;
        }
        catch (NoSuchJobException e) {
            throw new IllegalStateException("Unexpected non-existent job: " + jobName);
        }
    }

    public boolean isLaunchable(String jobName) {
        return this.jobRegistry.getJobNames().contains(jobName);
    }

    public JobExecution launch(String jobName, JobParameters jobParameters) throws NoSuchJobException, JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException, JobParametersInvalidException {
        JobExecution jobExecution;
        BatchStatus status;
        Job job = this.jobRegistry.getJob(jobName);
        JobExecution lastJobExecution = this.jobRepository.getLastJobExecution(jobName, jobParameters);
        boolean restart = false;
        if (lastJobExecution != null && (status = lastJobExecution.getStatus()).isUnsuccessful() && status != BatchStatus.ABANDONED) {
            restart = true;
        }
        if (job.getJobParametersIncrementer() != null && !restart) {
            jobParameters = job.getJobParametersIncrementer().getNext(jobParameters);
        }
        if ((jobExecution = this.jobLauncher.run(job, jobParameters)).isRunning()) {
            this.activeExecutions.add(jobExecution);
        }
        return jobExecution;
    }

    public Collection<JobExecution> listJobExecutions(int start, int count) {
        LinkedList executionList = new LinkedList();
        for (String jobName : this.jobRegistry.getJobNames()) {
            for (JobInstance jobInstance : this.jobExplorer.getJobInstances(jobName, 0, Integer.MAX_VALUE)) {
                executionList.addAll(this.jobExplorer.getJobExecutions(jobInstance));
            }
        }
        Collections.sort(executionList, new Comparator<JobExecution>(){

            @Override
            public int compare(JobExecution je1, JobExecution je2) {
                return je2.getStartTime().compareTo(je1.getStartTime());
            }
        });
        if (start >= executionList.size()) {
            return new LinkedList<JobExecution>();
        }
        int end = start + count;
        if (end >= executionList.size()) {
            end = executionList.size();
        }
        return executionList.subList(start, end);
    }

    public Collection<JobExecution> listJobExecutionsForJob(String jobName, int start, int count) throws NoSuchJobException {
        for (String name : this.jobRegistry.getJobNames()) {
            Iterator iterator;
            if (!name.contains(jobName) || !(iterator = this.jobExplorer.getJobInstances(jobName, 0, Integer.MAX_VALUE).iterator()).hasNext()) continue;
            JobInstance jobInstance = (JobInstance)iterator.next();
            List executionList = this.jobExplorer.getJobExecutions(jobInstance);
            if (start >= executionList.size()) {
                return new LinkedList<JobExecution>();
            }
            int end = start + count;
            if (end >= executionList.size()) {
                end = executionList.size();
            }
            return executionList.subList(start, end);
        }
        return null;
    }

    public Collection<JobInstance> listJobInstances(String jobName, int start, int count) throws NoSuchJobException {
        for (String name : this.jobRegistry.getJobNames()) {
            if (!name.contains(jobName)) continue;
            List instanceList = this.jobExplorer.getJobInstances(jobName, 0, Integer.MAX_VALUE);
            if (start >= instanceList.size()) {
                return new LinkedList<JobInstance>();
            }
            int end = start + count;
            if (end >= instanceList.size()) {
                end = instanceList.size();
            }
            return instanceList.subList(start, end);
        }
        return null;
    }

    public Collection<String> listJobs(int start, int count) {
        LinkedList jobNames = new LinkedList();
        jobNames.addAll(this.jobRegistry.getJobNames());
        Collections.sort(jobNames);
        if (start >= jobNames.size()) {
            return new LinkedList<String>();
        }
        int end = start + count;
        if (end >= jobNames.size()) {
            end = jobNames.size();
        }
        return jobNames.subList(start, end);
    }

    public Collection<StepExecution> listStepExecutionsForStep(String jobName, String stepName, int start, int count) throws NoSuchStepException {
        if (this.countStepExecutionsForStep(jobName, stepName) == 0) {
            throw new NoSuchStepException("No step executions exist with this step name: " + stepName);
        }
        LinkedList<StepExecution> steps = new LinkedList<StepExecution>();
        for (String name : this.jobRegistry.getJobNames()) {
            if (!name.contains(jobName)) continue;
            for (JobInstance jobInstance : this.jobExplorer.getJobInstances(jobName, 0, Integer.MAX_VALUE)) {
                for (JobExecution jobExecution : this.jobExplorer.getJobExecutions(jobInstance)) {
                    Collection stepExecutions = jobExecution.getStepExecutions();
                    for (StepExecution step : stepExecutions) {
                        if (!step.getStepName().contains(stepName)) continue;
                        steps.add(step);
                    }
                }
            }
        }
        if (start >= steps.size()) {
            return new LinkedList<StepExecution>();
        }
        int end = start + count;
        if (end >= steps.size()) {
            end = steps.size();
        }
        return steps.subList(start, end);
    }

    public JobExecution restart(Long jobExecutionId) throws NoSuchJobExecutionException, JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException, NoSuchJobException, JobParametersInvalidException {
        JobExecution target = this.getJobExecution(jobExecutionId);
        JobInstance lastInstance = target.getJobInstance();
        Job job = this.jobRegistry.getJob(lastInstance.getJobName());
        JobExecution jobExecution = this.jobLauncher.run(job, lastInstance.getJobParameters());
        if (jobExecution.isRunning()) {
            this.activeExecutions.add(jobExecution);
        }
        return jobExecution;
    }

    public JobExecution stop(Long jobExecutionId) throws NoSuchJobExecutionException, JobExecutionNotRunningException {
        JobExecution jobExecution = this.getJobExecution(jobExecutionId);
        if (!jobExecution.isRunning()) {
            throw new JobExecutionNotRunningException("JobExecution is not running and therefore cannot be stopped");
        }
        LOGGER.info("Stopping job execution: " + jobExecution);
        jobExecution.stop();
        this.jobRepository.update(jobExecution);
        return jobExecution;
    }

    public int stopAll() {
        LinkedList<JobExecution> allExecutions = new LinkedList<JobExecution>();
        for (String jobName : this.jobRegistry.getJobNames()) {
            for (JobInstance jobInstance : this.jobExplorer.getJobInstances(jobName, 0, Integer.MAX_VALUE)) {
                for (JobExecution jobExecution : this.jobExplorer.getJobExecutions(jobInstance)) {
                    if (!jobExecution.isRunning()) continue;
                    allExecutions.add(jobExecution);
                }
            }
        }
        for (JobExecution jobExecution : allExecutions) {
            jobExecution.stop();
            this.jobRepository.update(jobExecution);
        }
        return allExecutions.size();
    }

    public void setShutdownTimeout(int shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
    }

    @Override
    public String getCronExpression(String jobName) {
        return this.scheduleRepository.getCronExpression(jobName);
    }

    @Override
    public Date getNextFireDate(String jobName) {
        return this.scheduleRepository.getNextFireDate(jobName);
    }

    @Override
    public ComponentContainer getComponentContainer() {
        return this.componentContainer;
    }

    @Override
    public void setComponentContainer(ComponentContainer componentContainer) {
        this.componentContainer = componentContainer;
    }

    @Override
    public boolean contains(String jobName) {
        return this.jobRegistry.getJobNames().contains(jobName);
    }
}

