/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.batch.impl.quartz;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.scheduling.quartz.SimpleTriggerBean;
import org.springframework.util.Assert;
import org.trpr.platform.batch.impl.quartz.SimpleScheduleRepository;
import org.trpr.platform.batch.impl.spring.SpringBatchComponentContainer;
import org.trpr.platform.batch.impl.spring.job.ChainingJobExecutionListener;

public class JobCompletionTriggerBean
extends SimpleTriggerBean {
    private static final long serialVersionUID = 1L;
    private String followJob;
    private long startDelayInMs;

    public void afterPropertiesSet() throws ParseException {
        Assert.notNull((Object)this.followJob, (String)"'followJob' must be set to a valid job name");
        super.afterPropertiesSet();
        AbstractApplicationContext commonBeansContext = SpringBatchComponentContainer.getCommonBatchBeansContext();
        ((ChainingJobExecutionListener)commonBeansContext.getBean(ChainingJobExecutionListener.class)).addJobCompletionTrigger(this);
        this.setStartTime(new Date(0L));
        this.setRepeatCount(0);
        this.setMisfireInstruction(4);
        Calendar cal = Calendar.getInstance();
        cal.add(1, 1000);
        this.setNextFireTime(cal.getTime());
    }

    public void setStartDelay(long startDelay) {
        super.setStartDelay(startDelay);
        this.startDelayInMs = startDelay;
    }

    public Date getNextFireTime() {
        AbstractApplicationContext commonBeansContext = SpringBatchComponentContainer.getCommonBatchBeansContext();
        Date nextFireTime = ((SimpleScheduleRepository)commonBeansContext.getBean(SimpleScheduleRepository.class)).getNextFireDate(this.getFollowJob());
        if (nextFireTime != null) {
            nextFireTime = new Date(nextFireTime.getTime() + this.startDelayInMs);
            return nextFireTime;
        }
        return super.getNextFireTime();
    }

    public String getFollowJob() {
        return this.followJob;
    }

    public void setFollowJob(String followJob) {
        this.followJob = followJob;
    }

    public long getStartDelay() {
        return this.startDelayInMs;
    }
}

