/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.batch.impl.spring.job;

import java.util.LinkedList;
import java.util.List;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;
import org.trpr.platform.batch.impl.quartz.JobCompletionTriggerBean;
import org.trpr.platform.batch.impl.spring.jmx.JobAdministrator;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class ChainingJobExecutionListener
implements JobExecutionListener {
    private static final Logger LOGGER = LogFactory.getLogger(ChainingJobExecutionListener.class);
    private List<JobCompletionTriggerBean> jobCompletionTriggers = new LinkedList<JobCompletionTriggerBean>();
    private JobAdministrator jobAdministrator;

    public void beforeJob(JobExecution je) {
    }

    public void addJobCompletionTrigger(JobCompletionTriggerBean jobCompletionTriggerBean) {
        if (!this.jobCompletionTriggers.contains((Object)jobCompletionTriggerBean)) {
            this.jobCompletionTriggers.add(jobCompletionTriggerBean);
        }
    }

    public void afterJob(JobExecution je) {
        String jobName = je.getJobInstance().getJobName();
        for (JobCompletionTriggerBean jobCompletionTriggerBean : this.jobCompletionTriggers) {
            if (!jobCompletionTriggerBean.getFollowJob().equalsIgnoreCase(jobName)) continue;
            if (jobCompletionTriggerBean.getStartDelay() > 0L) {
                LOGGER.info("Using Job administrator to run job : {} on completion of job : {} with delay (in ms) : " + jobCompletionTriggerBean.getStartDelay(), (Object)((Job)jobCompletionTriggerBean.getJobDetail().getJobDataMap().get((Object)"jobName")).getName(), (Object)jobName);
                try {
                    Thread.sleep(jobCompletionTriggerBean.getStartDelay());
                }
                catch (InterruptedException e) {
                    LOGGER.info("Sleep interrupted for running job : {} on completion of job : {}. Running job now.", (Object)((Job)jobCompletionTriggerBean.getJobDetail().getJobDataMap().get((Object)"jobName")).getName(), (Object)jobName);
                }
                this.jobAdministrator.runJob(((Job)jobCompletionTriggerBean.getJobDetail().getJobDataMap().get((Object)"jobName")).getName());
                continue;
            }
            LOGGER.info("Using Job administrator to run job : {} on completion of job : {}", (Object)((Job)jobCompletionTriggerBean.getJobDetail().getJobDataMap().get((Object)"jobName")).getName(), (Object)jobName);
            this.jobAdministrator.runJob(((Job)jobCompletionTriggerBean.getJobDetail().getJobDataMap().get((Object)"jobName")).getName());
        }
    }

    public JobAdministrator getJobAdministrator() {
        return this.jobAdministrator;
    }

    public void setJobAdministrator(JobAdministrator jobAdministrator) {
        this.jobAdministrator = jobAdministrator;
    }
}

