/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.batch.impl.quartz;

import java.util.Calendar;
import java.util.Date;
import org.quartz.JobDetail;
import org.quartz.impl.triggers.SimpleTriggerImpl;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.util.Assert;
import org.trpr.platform.batch.impl.quartz.SimpleScheduleRepository;
import org.trpr.platform.batch.impl.spring.SpringBatchComponentContainer;
import org.trpr.platform.batch.impl.spring.job.ChainingJobExecutionListener;

public class JobCompletionTriggerBean
extends SimpleTriggerImpl
implements BeanNameAware,
InitializingBean {
    private static final long serialVersionUID = 1L;
    private String followJob;
    private String beanName;
    private long startDelay;
    private JobDetail jobDetail;

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.followJob, (String)"'followJob' must be set to a valid job name");
        if (this.getName() == null) {
            this.setName(this.beanName);
        }
        if (this.getGroup() == null) {
            this.setGroup("DEFAULT");
        }
        if (this.jobDetail != null) {
            this.getJobDataMap().put("jobDetail", (Object)this.jobDetail);
        }
        if (this.getStartDelay() > 0L || this.getStartTime() == null) {
            Calendar c = Calendar.getInstance();
            c.setTimeInMillis(System.currentTimeMillis() + this.getStartDelay());
            this.setStartTime(c.getTime());
        }
        this.setJobKey(this.jobDetail.getKey());
        this.setStartTime(new Date(0L));
        this.setRepeatInterval(Long.MAX_VALUE);
        AbstractApplicationContext commonBeansContext = SpringBatchComponentContainer.getCommonBatchBeansContext();
        ((ChainingJobExecutionListener)commonBeansContext.getBean(ChainingJobExecutionListener.class)).addJobCompletionTrigger(this);
        this.setStartTime(new Date(0L));
        this.setRepeatCount(0);
        this.setMisfireInstruction(4);
        Calendar cal = Calendar.getInstance();
        cal.add(1, 1000);
        this.setNextFireTime(cal.getTime());
    }

    public Date getNextFireTime() {
        AbstractApplicationContext commonBeansContext = SpringBatchComponentContainer.getCommonBatchBeansContext();
        Date nextFireTime = ((SimpleScheduleRepository)commonBeansContext.getBean(SimpleScheduleRepository.class)).getNextFireDate(this.getFollowJob());
        if (nextFireTime != null) {
            nextFireTime = new Date(nextFireTime.getTime() + this.startDelay);
            return nextFireTime;
        }
        return super.getNextFireTime();
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public String getFollowJob() {
        return this.followJob;
    }

    public void setFollowJob(String followJob) {
        this.followJob = followJob;
    }

    public void setJobDetail(JobDetail jobDetail) {
        this.jobDetail = jobDetail;
    }

    public JobDetail getJobDetail() {
        return this.jobDetail;
    }

    public void setStartDelay(long startDelay) {
        this.startDelay = startDelay;
    }

    public long getStartDelay() {
        return this.startDelay;
    }
}

