/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.batch.impl.job.ha;

import com.netflix.curator.framework.CuratorFramework;
import com.netflix.curator.framework.recipes.leader.LeaderLatch;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.batch.core.job.flow.FlowJob;
import org.trpr.platform.batch.impl.spring.jmx.JMXJobUtils;
import org.trpr.platform.batch.impl.spring.job.BatchJob;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class HABatchJob
extends BatchJob {
    private static final String JOB_SHARD = "jobShard";
    private static final String JOB_NAME = "jobName";
    private static final String LEADER_LATCH_TIMEOUT = "leaderLatchTimeout";
    private static final String CURATOR_CLIENT = "curatorClient";
    private static final int DEFAULT_TIMEOUT_MS = 60000;
    private static final String ZK_PATH_PREFIX = "/Batch/Latch/";
    private static final Logger LOGGER = LogFactory.getLogger(HABatchJob.class);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        block14: {
            String latchValue = (String)context.getJobDetail().getJobDataMap().get((Object)JOB_SHARD);
            if (latchValue == null) {
                latchValue = ((FlowJob)context.getJobDetail().getJobDataMap().get((Object)JOB_NAME)).getName();
            }
            LeaderLatch leaderLatch = new LeaderLatch((CuratorFramework)context.getJobDetail().getJobDataMap().get((Object)CURATOR_CLIENT), ZK_PATH_PREFIX + latchValue);
            try {
                try {
                    leaderLatch.start();
                    long leaderLatchTimeout = context.getJobDetail().getJobDataMap().get((Object)LEADER_LATCH_TIMEOUT) == null ? 60000L : Long.valueOf((String)context.getJobDetail().getJobDataMap().get((Object)LEADER_LATCH_TIMEOUT));
                    leaderLatch.await(leaderLatchTimeout, TimeUnit.MILLISECONDS);
                    if (leaderLatch.hasLeadership()) {
                        super.execute(context);
                        JMXJobUtils jmxJobUtils = new JMXJobUtils();
                        jmxJobUtils.waitForJobExecution(((FlowJob)context.getJobDetail().getJobDataMap().get((Object)JOB_NAME)).getName(), 1000L);
                        break block14;
                    }
                    LOGGER.info("Not the negotiated leader and therefore not executing job : " + latchValue);
                }
                catch (Exception e) {
                    LOGGER.error("Error acquiring Leader Latch for : " + latchValue + ". Cannot execute job!. Error is : " + e.getMessage(), (Throwable)e);
                    if (leaderLatch == null) break block14;
                    try {
                        leaderLatch.close();
                    }
                    catch (IOException e2) {
                        LOGGER.error("Error relinquishing/closing Leader Latch for : " + latchValue + ". Error is : " + e2.getMessage(), (Throwable)e2);
                    }
                }
            }
            finally {
                if (leaderLatch != null) {
                    try {
                        leaderLatch.close();
                    }
                    catch (IOException e) {
                        LOGGER.error("Error relinquishing/closing Leader Latch for : " + latchValue + ". Error is : " + e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }
}

