/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.dataaccess.hbase.mappings.config;

import java.beans.PropertyDescriptor;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.trpr.dataaccess.hbase.model.config.ColumnDefinition;
import org.trpr.dataaccess.hbase.model.config.CompositeRowKey;
import org.trpr.dataaccess.hbase.model.config.HbaseMapping;
import org.trpr.dataaccess.hbase.model.config.RowKeyDefinition;
import org.trpr.dataaccess.hbase.model.config.RowKeyMember;
import org.trpr.platform.integration.impl.xml.XMLTranscoderImpl;
import org.trpr.platform.runtime.impl.config.FileLocator;
import org.trpr.platform.runtime.spi.config.ConfigurationException;

public class HBaseMappingContainer {
    private Map<String, HbaseMapping> configs = new HashMap<String, HbaseMapping>();
    private static final Log logger = LogFactory.getLog(HBaseMappingContainer.class);

    public void init(List<String> mappingFiles) throws ConfigurationException {
        for (String mappingFile : mappingFiles) {
            try {
                String xml = this.readFileToString(mappingFile);
                HbaseMapping mapping = (HbaseMapping)new XMLTranscoderImpl().unmarshal(xml, HbaseMapping.class);
                this.validate(mappingFile, mapping);
                this.configs.put(mapping.getHbaseClass().getName(), mapping);
            }
            catch (Exception e) {
                logger.error((Object)"Error initializing HBase configurations", (Throwable)e);
                throw new ConfigurationException("Error initializing HBase configurations", (Throwable)e);
            }
        }
    }

    private String readFileToString(String mappingFile) throws ConfigurationException {
        try {
            FileInputStream stream = new FileInputStream(FileLocator.findUniqueFile((String)mappingFile));
            List lines = IOUtils.readLines((InputStream)stream);
            StringBuffer strBuf = new StringBuffer();
            for (String s : lines) {
                strBuf.append(s);
                strBuf.append("\n");
            }
            return strBuf.toString();
        }
        catch (Exception e) {
            throw new ConfigurationException("Error while reading Hbase mapping file : " + mappingFile, (Throwable)e);
        }
    }

    private void validate(String mappingFileName, HbaseMapping mapping) throws ConfigurationException {
        try {
            Object o = Class.forName(mapping.getHbaseClass().getName()).newInstance();
            RowKeyDefinition rowKeyDefinition = mapping.getHbaseClass().getRowkeyDefinition();
            if (rowKeyDefinition == null) {
                throw new ConfigurationException("No row key definition found in " + mappingFileName);
            }
            try {
                if (rowKeyDefinition.getCompositeRowKey() != null) {
                    CompositeRowKey compositeRowKey = rowKeyDefinition.getCompositeRowKey();
                    if (compositeRowKey.getRowKeyMember().size() == 0) {
                        throw new ConfigurationException("At least one row key member must be specified when using Composite Row key in " + mappingFileName);
                    }
                    for (RowKeyMember member : compositeRowKey.getRowKeyMember()) {
                        PropertyDescriptor propertyDescriptor = PropertyUtils.getPropertyDescriptor(o, (String)member.getValueAttribute());
                        if (propertyDescriptor == null) {
                            throw new ConfigurationException("Attribute " + member.getValueAttribute() + " not found in class: " + mapping.getHbaseClass().getName() + " in file " + mappingFileName);
                        }
                        if (propertyDescriptor.getPropertyType().getName().equals(member.getValueType()) || "byte[]".equals(rowKeyDefinition.getValueType())) continue;
                        throw new ConfigurationException("Wrong value specified for " + member.getValueAttribute() + " in " + mappingFileName);
                    }
                } else {
                    PropertyDescriptor propertyDescriptor = PropertyUtils.getPropertyDescriptor(o, (String)rowKeyDefinition.getValueAttribute());
                    if (propertyDescriptor == null) {
                        throw new ConfigurationException("Attribute " + rowKeyDefinition.getValueAttribute() + " not found in class: " + mapping.getHbaseClass().getName() + " in file " + mappingFileName);
                    }
                    if (!propertyDescriptor.getPropertyType().getName().equals(rowKeyDefinition.getValueType()) && !"byte[]".equals(rowKeyDefinition.getValueType())) {
                        throw new ConfigurationException("Wrong value specified for " + rowKeyDefinition.getValueAttribute() + " in " + mappingFileName);
                    }
                }
                for (ColumnDefinition columnDefinition : mapping.getHbaseClass().getColumnDefinition()) {
                    PropertyDescriptor propertyDescriptor = PropertyUtils.getPropertyDescriptor(o, (String)columnDefinition.getValueAttribute());
                    if (propertyDescriptor == null) {
                        throw new ConfigurationException("Attribute " + columnDefinition.getValueAttribute() + " not found in class: " + mapping.getHbaseClass().getName() + " in file " + mappingFileName);
                    }
                    if (!propertyDescriptor.getPropertyType().getName().equals(columnDefinition.getValueType()) && !"byte[]".equals(columnDefinition.getValueType())) {
                        throw new ConfigurationException("Wrong value type specified for " + columnDefinition.getValueAttribute() + " in " + mappingFileName);
                    }
                    if (!StringUtils.isBlank((String)columnDefinition.getColumnQualifier()) || !StringUtils.isBlank((String)columnDefinition.getColumnQualifierAttribute())) continue;
                    throw new ConfigurationException("Either \"columnFamily\" or \"columnQualifierAttribute\" must be specified for " + columnDefinition.getValueAttribute() + " in " + mappingFileName);
                }
            }
            catch (InvocationTargetException e) {
                throw new ConfigurationException("Attribute not accessible " + rowKeyDefinition.getValueAttribute() + " in " + mappingFileName, (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw new ConfigurationException("Invalid attribute " + rowKeyDefinition.getValueAttribute() + " in " + mappingFileName, (Throwable)e);
            }
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("Class not found : " + mapping.getHbaseClass().getName(), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ConfigurationException("Class not instantiable : " + mapping.getHbaseClass().getName(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException("Class constructor not accessible : " + mapping.getHbaseClass().getName(), (Throwable)e);
        }
    }

    public HbaseMapping getMappingForClass(String className) {
        return this.configs.get(className);
    }
}

