/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.dataaccess.hbase.persistence;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.HTablePool;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.trpr.dataaccess.hbase.mappings.config.HBaseMappingContainer;
import org.trpr.dataaccess.hbase.model.config.ColumnDefinition;
import org.trpr.dataaccess.hbase.model.config.HbaseClass;
import org.trpr.dataaccess.hbase.model.config.HbaseMapping;
import org.trpr.dataaccess.hbase.model.config.RowKeyDefinition;
import org.trpr.dataaccess.hbase.model.config.RowKeyMember;
import org.trpr.dataaccess.hbase.persistence.HBaseCriteria;
import org.trpr.dataaccess.hbase.persistence.entity.HBaseEntity;
import org.trpr.dataaccess.hbase.serializer.DateSerializer;
import org.trpr.dataaccess.hbase.serializer.IntegerSerializer;
import org.trpr.dataaccess.hbase.serializer.LongSerializer;
import org.trpr.dataaccess.hbase.serializer.StringSerializer;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;
import org.trpr.platform.core.spi.persistence.PersistenceException;
import org.trpr.platform.core.spi.persistence.PersistentEntity;
import org.trpr.platform.core.spi.persistence.Serializer;
import org.trpr.platform.runtime.spi.config.ConfigurationException;

public class HBaseHandlerDelegate
implements InitializingBean {
    private static final Logger LOGGER = LogFactory.getLogger(HBaseHandlerDelegate.class);
    private Map<String, Serializer> classNameToSerializerMap = new HashMap<String, Serializer>();
    private HBaseMappingContainer hbaseMappingContainer;
    private Boolean useWAL = true;
    private Boolean useAutoFlush = true;

    public HBaseHandlerDelegate() {
    }

    public HBaseHandlerDelegate(HBaseMappingContainer hbaseMappingContainer) {
        this.classNameToSerializerMap.put("java.lang.String", new StringSerializer());
        this.classNameToSerializerMap.put("java.lang.Long", new LongSerializer());
        this.classNameToSerializerMap.put("java.lang.Integer", new IntegerSerializer());
        this.classNameToSerializerMap.put("java.util.Date", new DateSerializer());
        this.setHBaseMappingContainer(hbaseMappingContainer);
    }

    public void setClassNameToSerializerMap(Map<String, Serializer> classNameToSerializerMap) {
        this.classNameToSerializerMap.putAll(classNameToSerializerMap);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.classNameToSerializerMap, (String)"The 'classNameToSerializerMap' may not be null");
    }

    void setHBaseMappingContainer(HBaseMappingContainer hbaseMappingContainer) {
        this.hbaseMappingContainer = hbaseMappingContainer;
    }

    public PersistentEntity makePersistent(HBaseEntity entity, HTablePool hbaseTablePool) throws PersistenceException {
        HbaseMapping metadata = this.hbaseMappingContainer.getMappingForClass(((Object)((Object)entity)).getClass().getName());
        this.addEntity(hbaseTablePool, metadata, entity);
        return entity;
    }

    public void makeTransient(HBaseEntity entity, HTablePool hbaseTablePool) throws PersistenceException {
        HbaseMapping metadata = this.hbaseMappingContainer.getMappingForClass(((Object)((Object)entity)).getClass().getName());
        this.deleteEntity(hbaseTablePool, entity, metadata);
    }

    private void addEntity(HTablePool hbaseTablePool, HbaseMapping metadata, HBaseEntity entity) throws PersistenceException {
        HTableInterface table = null;
        HbaseClass classDefinition = metadata.getHbaseClass();
        try {
            table = hbaseTablePool.getTable(classDefinition.getTable());
            table.setAutoFlush(this.useAutoFlush.booleanValue());
            Put put = new Put(this.constructRowKey((PersistentEntity)entity, classDefinition.getRowkeyDefinition()));
            put.setWriteToWAL(this.useWAL.booleanValue());
            for (ColumnDefinition column : classDefinition.getColumnDefinition()) {
                put.add(this.getColumnFamilyInBytes(column), this.getColumnQualifierInBytes((PersistentEntity)entity, column), this.getColumnValueInBytes((PersistentEntity)entity, column));
            }
            table.put(put);
        }
        catch (Exception e) {
            throw new PersistenceException("Exception in putData of " + classDefinition.getTable(), (Throwable)e);
        }
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Error returning table to the pool : " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void deleteEntity(HTablePool hbaseTablePool, HBaseEntity entity, HbaseMapping metadata) throws PersistenceException {
        HTableInterface table = null;
        try {
            table = hbaseTablePool.getTable(metadata.getHbaseClass().getTable());
            Delete delete = new Delete(this.constructRowKey((PersistentEntity)entity, metadata.getHbaseClass().getRowkeyDefinition()));
            table.delete(delete);
        }
        catch (Exception e) {
            throw new PersistenceException("Failed to delete entry for table " + metadata.getHbaseClass().getTable(), (Throwable)e);
        }
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Error returning table to the pool : " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public HBaseEntity findEntity(HTablePool hbaseTablePool, HBaseEntity entity, HbaseMapping metadata) throws PersistenceException {
        HTableInterface table = null;
        try {
            Get g;
            Result result;
            table = hbaseTablePool.getTable(metadata.getHbaseClass().getTable());
            byte[] rowKey = this.constructRowKey((PersistentEntity)entity, metadata.getHbaseClass().getRowkeyDefinition());
            if (rowKey != null && rowKey.length > 0 && !(result = table.get(g = this.constructGetQuery(metadata, entity, rowKey))).isEmpty()) {
                HBaseEntity hBaseEntity = this.constructEntityFromResultRow(metadata, result, entity);
                return hBaseEntity;
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception occurred in searchData:", (Throwable)e);
            throw new PersistenceException("Exception occcurred while performing search for table " + metadata.getHbaseClass().getTable(), (Throwable)e);
        }
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Error returning table to the pool : " + e.getMessage(), (Throwable)e);
                }
            }
        }
        return null;
    }

    public Collection<PersistentEntity> findEntities(HTablePool hbaseTablePool, HBaseCriteria criteria, HbaseMapping metadata) throws PersistenceException {
        ArrayList<PersistentEntity> searchResultList = new ArrayList<PersistentEntity>();
        HTableInterface table = null;
        try {
            table = hbaseTablePool.getTable(metadata.getHbaseClass().getTable());
            Scan s = this.constructScanQuery(metadata, criteria);
            ResultScanner scanner = table.getScanner(s);
            int startIndex = criteria.getFirstResult();
            int maxResults = criteria.getMaxResults();
            int count = 0;
            Result resultRow = scanner.next();
            while (resultRow != null) {
                if (!resultRow.isEmpty() && count >= startIndex) {
                    searchResultList.add((PersistentEntity)this.constructEntityFromResultRow(metadata, resultRow, (HBaseEntity)((Object)criteria.getManagedClass().newInstance())));
                }
                if (++count >= maxResults) {
                    break;
                }
                resultRow = scanner.next();
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception occurred in searchData:", (Throwable)e);
            throw new PersistenceException("Exception occcurred while performing search for table " + metadata.getHbaseClass().getTable(), (Throwable)e);
        }
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Error returning table to the pool : " + e.getMessage(), (Throwable)e);
                }
            }
        }
        return searchResultList;
    }

    private Get constructGetQuery(HbaseMapping metadata, HBaseEntity entity, byte[] rowId) throws ConfigurationException {
        Get getRequest = null;
        try {
            getRequest = new Get(rowId);
            HBaseCriteria queryCriteria = (HBaseCriteria)entity.getCriteriaForLoad();
            if (queryCriteria != null) {
                long startTimestamp;
                int versions;
                int n = versions = queryCriteria.getParameter("numVersionsToFetch") == null ? 1 : Integer.valueOf((String)queryCriteria.getParameter("numVersionsToFetch"));
                if (versions > 1) {
                    getRequest.setMaxVersions(versions);
                }
                long l = startTimestamp = queryCriteria.getParameter("startTimestamp") == null ? 0L : Long.valueOf((String)queryCriteria.getParameter("startTimestamp"));
                if (startTimestamp != 0L) {
                    long endTimestamp;
                    long l2 = endTimestamp = queryCriteria.getParameter("endTimestamp") == null ? 0L : Long.valueOf((String)queryCriteria.getParameter("endTimestamp"));
                    if (endTimestamp == 0L) {
                        queryCriteria.addParameter("endTimestamp", System.currentTimeMillis());
                    }
                    getRequest.setTimeRange(startTimestamp, endTimestamp);
                }
            }
            for (ColumnDefinition column : metadata.getHbaseClass().getColumnDefinition()) {
                getRequest.addColumn(this.getColumnFamilyInBytes(column), this.getColumnQualifierInBytes((PersistentEntity)entity, column));
            }
        }
        catch (IOException e) {
            throw new ConfigurationException("Exception occurred while constructing get query for table " + metadata.getHbaseClass().getTable() + " using entity " + ((Object)((Object)entity)).toString(), (Throwable)e);
        }
        return getRequest;
    }

    private Scan constructScanQuery(HbaseMapping metadata, HBaseCriteria queryCriteria) throws ConfigurationException {
        Scan scanRequest = null;
        try {
            if (queryCriteria != null) {
                if (queryCriteria.getScan() != null) {
                    scanRequest = queryCriteria.getScan();
                } else {
                    long startTimestamp;
                    int versions;
                    scanRequest = new Scan();
                    int n = versions = queryCriteria.getParameter("numVersionsToFetch") == null ? 1 : Integer.valueOf((String)queryCriteria.getParameter("numVersionsToFetch"));
                    if (versions > 1) {
                        scanRequest.setMaxVersions(versions);
                    }
                    long l = startTimestamp = queryCriteria.getParameter("startTimestamp") == null ? 0L : Long.valueOf((String)queryCriteria.getParameter("startTimestamp"));
                    if (startTimestamp != 0L) {
                        long endTimestamp;
                        long l2 = endTimestamp = queryCriteria.getParameter("endTimestamp") == null ? 0L : Long.valueOf((String)queryCriteria.getParameter("endTimestamp"));
                        if (endTimestamp == 0L) {
                            queryCriteria.addParameter("endTimestamp", System.currentTimeMillis());
                        }
                        scanRequest.setTimeRange(startTimestamp, endTimestamp);
                    }
                    byte[] startKey = (byte[])queryCriteria.getParameter("startKey");
                    byte[] endKey = (byte[])queryCriteria.getParameter("endKey");
                    if (startKey != null) {
                        scanRequest.setStartRow(startKey);
                    }
                    if (endKey != null) {
                        scanRequest.setStopRow(endKey);
                    }
                }
            } else {
                scanRequest = new Scan();
            }
        }
        catch (IOException e) {
            throw new ConfigurationException("Error during constructing scan query, given time range is not valid for table " + metadata.getHbaseClass().getTable(), (Throwable)e);
        }
        return scanRequest;
    }

    private HBaseEntity constructEntityFromResultRow(HbaseMapping metadata, Result resultRow, HBaseEntity resEntity) throws ConfigurationException {
        try {
            byte[] rowKey = resultRow.getRow();
            this.populateRowKeyAttributes(metadata, (PersistentEntity)resEntity, rowKey);
            List keyValuePairs = resultRow.list();
            if (keyValuePairs != null && keyValuePairs.size() > 0) {
                for (KeyValue keyValue : keyValuePairs) {
                    String columnQualifier;
                    String columnFamily = new String(keyValue.getFamily());
                    ColumnDefinition columnDefinition = this.findColumnDefinition(metadata, columnFamily, columnQualifier = new String(keyValue.getQualifier()));
                    if (columnDefinition == null) continue;
                    this.setAttribute((PersistentEntity)resEntity, columnDefinition.getValueAttribute(), this.convertToObject(PropertyUtils.getPropertyDescriptor((Object)((Object)resEntity), (String)columnDefinition.getValueAttribute()).getPropertyType(), keyValue.getValue()));
                    if (!StringUtils.isNotBlank((String)columnDefinition.getColumnQualifierAttribute())) continue;
                    byte[] columnQualifierAttributeValue = keyValue.getQualifier();
                    if (StringUtils.isNotBlank((String)columnDefinition.getColumnQualifier())) {
                        columnQualifierAttributeValue = Bytes.tail((byte[])columnQualifierAttributeValue, (int)(columnQualifierAttributeValue.length - columnDefinition.getColumnQualifier().getBytes().length));
                    }
                    this.setAttribute((PersistentEntity)resEntity, columnDefinition.getColumnQualifierAttribute(), this.convertToObject(PropertyUtils.getPropertyDescriptor((Object)((Object)resEntity), (String)columnDefinition.getColumnQualifierAttribute()).getPropertyType(), columnQualifierAttributeValue));
                }
            }
        }
        catch (Exception e) {
            throw new ConfigurationException("Error while creating entity for table " + metadata.getHbaseClass().getTable(), (Throwable)e);
        }
        return resEntity;
    }

    private void populateRowKeyAttributes(HbaseMapping metadata, PersistentEntity resEntity, byte[] rowKey) throws ConfigurationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (metadata.getHbaseClass().getRowkeyDefinition().getCompositeRowKey() != null) {
            List<RowKeyMember> rowKeyMembers = metadata.getHbaseClass().getRowkeyDefinition().getCompositeRowKey().getRowKeyMember();
            int startIndex = 0;
            for (RowKeyMember rowKeyMember : rowKeyMembers) {
                int endIndex = startIndex + rowKeyMember.getValueLength();
                byte[] part = this.extractBytes(rowKey, startIndex, endIndex);
                this.setAttribute(resEntity, rowKeyMember.getValueAttribute(), this.convertToObject(PropertyUtils.getPropertyDescriptor((Object)resEntity, (String)rowKeyMember.getValueAttribute()).getPropertyType(), part));
                startIndex = endIndex;
            }
        } else {
            this.setAttribute(resEntity, metadata.getHbaseClass().getRowkeyDefinition().getValueAttribute(), this.convertToObject(PropertyUtils.getPropertyDescriptor((Object)resEntity, (String)metadata.getHbaseClass().getRowkeyDefinition().getValueAttribute()).getPropertyType(), rowKey));
        }
    }

    private byte[] extractBytes(byte[] rowKey, int startIndex, int endIndex) {
        byte[] extractedBytes = new byte[endIndex - startIndex];
        int i = startIndex;
        int j = 0;
        while (i < endIndex) {
            extractedBytes[j] = rowKey[i];
            ++i;
            ++j;
        }
        return extractedBytes;
    }

    private ColumnDefinition findColumnDefinition(HbaseMapping metadata, String columnFamilyFromHbaseRow, String columnQualifierFromHbaseRow) {
        for (ColumnDefinition columnDefinition : metadata.getHbaseClass().getColumnDefinition()) {
            if (columnFamilyFromHbaseRow == null || !columnFamilyFromHbaseRow.equals(columnDefinition.getColumnFamily()) || columnQualifierFromHbaseRow == null || !columnQualifierFromHbaseRow.startsWith(columnDefinition.getColumnQualifier())) continue;
            return columnDefinition;
        }
        return null;
    }

    private void setAttribute(PersistentEntity entity, String attribute, Object value) throws ConfigurationException {
        try {
            if (StringUtils.isNotBlank((String)attribute)) {
                PropertyUtils.setProperty((Object)entity, (String)attribute, (Object)value);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error setting attribute " + attribute, (Throwable)e);
        }
    }

    private Object convertToObject(Class targetClass, byte[] bytes) throws ConfigurationException {
        if (bytes != null) {
            if (targetClass == byte[].class) {
                return bytes;
            }
            Serializer serializer = this.classNameToSerializerMap.get(targetClass.getName());
            if (serializer != null) {
                return serializer.toObject(bytes);
            }
            throw new ConfigurationException("Don't know how to serialize " + targetClass.getName());
        }
        return null;
    }

    private byte[] getColumnFamilyInBytes(ColumnDefinition column) {
        return Bytes.toBytes((String)column.getColumnFamily());
    }

    private byte[] getColumnValueInBytes(PersistentEntity entity, ColumnDefinition column) throws ConfigurationException {
        return this.convertToBytes(this.getAttribute(entity, column.getValueAttribute()));
    }

    private byte[] getColumnQualifierInBytes(PersistentEntity entity, ColumnDefinition column) throws ConfigurationException {
        byte[] columnQualifier = new byte[]{};
        if (StringUtils.isNotBlank((String)column.getColumnQualifier())) {
            columnQualifier = Bytes.add((byte[])columnQualifier, (byte[])column.getColumnQualifier().getBytes());
        }
        if (StringUtils.isNotBlank((String)column.getColumnQualifierAttribute())) {
            try {
                columnQualifier = Bytes.add((byte[])columnQualifier, (byte[])this.convertToBytes(this.getAttribute(entity, column.getColumnQualifierAttribute())));
            }
            catch (Exception e) {
                LOGGER.error("Error reading column qualifier value for : " + column.getColumnQualifierAttribute(), (Throwable)e);
            }
        }
        if (columnQualifier.length == 0) {
            throw new ConfigurationException("Could not determine the column qualifier value for a column from family: " + column.getColumnFamily());
        }
        return columnQualifier;
    }

    private final byte[] constructRowKey(PersistentEntity obj, RowKeyDefinition rowIdMetaData) throws ConfigurationException {
        try {
            if (rowIdMetaData.getCompositeRowKey() != null) {
                List<RowKeyMember> rowKeyMembers = rowIdMetaData.getCompositeRowKey().getRowKeyMember();
                byte[] idValue = new byte[]{};
                for (RowKeyMember rowKeyMember : rowKeyMembers) {
                    idValue = Bytes.add((byte[])idValue, (byte[])this.convertToBytes(this.getAttribute(obj, rowKeyMember.getValueAttribute())));
                }
                return idValue;
            }
            byte[] idValue = this.convertToBytes(this.getAttribute(obj, rowIdMetaData.getValueAttribute()));
            return idValue;
        }
        catch (Exception e) {
            LOGGER.error("Error reading ID attribute : " + rowIdMetaData.getValueAttribute(), (Throwable)e);
            return new byte[0];
        }
    }

    private byte[] convertToBytes(Object value) throws ConfigurationException {
        if (value != null) {
            if (value instanceof byte[]) {
                return (byte[])value;
            }
            Serializer serializer = this.classNameToSerializerMap.get(value.getClass().getName());
            if (serializer != null) {
                return serializer.toBytes(value);
            }
            throw new ConfigurationException("Don't know how to serialize " + value.getClass().getName());
        }
        return new byte[0];
    }

    private Object getAttribute(Object entity, String attribute) {
        Object returnValue = null;
        try {
            returnValue = PropertyUtils.getProperty((Object)entity, (String)attribute);
        }
        catch (Exception e) {
            LOGGER.error("Error reading attribute : '" + attribute + "' in class " + entity.getClass().getName(), (Throwable)e);
        }
        return returnValue;
    }

    public void setUseWAL(Boolean useWAL) {
        this.useWAL = useWAL;
    }

    public void setUseAutoFlush(Boolean useAutoFlush) {
        this.useAutoFlush = useAutoFlush;
    }
}

