/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.dataaccess.hbase;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTableFactory;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.HTableInterfaceFactory;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowLock;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.ipc.CoprocessorProtocol;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.PoolMap;
import org.trpr.dataaccess.hbase.auth.AuthenticationProvider;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class HTablePool
implements Closeable {
    private static final Logger LOGGER = LogFactory.getLogger(HTablePool.class);
    protected PoolMap<String, HTableInterface> tables;
    protected int maxSize;
    protected PoolMap.PoolType poolType;
    protected Configuration config;
    protected HTableInterfaceFactory tableFactory;
    protected Integer callConnectionValidityCheckMinutes;
    protected AuthenticationProvider authenticationProvider;

    public HTablePool() {
        this(HBaseConfiguration.create(), Integer.MAX_VALUE);
    }

    public HTablePool(Configuration config, int maxSize) {
        this(config, maxSize, null, null);
    }

    public HTablePool(Configuration config, int maxSize, HTableInterfaceFactory tableFactory) {
        this(config, maxSize, tableFactory, PoolMap.PoolType.Reusable);
    }

    public HTablePool(Configuration config, int maxSize, PoolMap.PoolType poolType) {
        this(config, maxSize, null, poolType);
    }

    public HTablePool(Configuration config, int maxSize, HTableInterfaceFactory tableFactory, PoolMap.PoolType poolType) {
        this.config = config == null ? HBaseConfiguration.create() : config;
        this.maxSize = maxSize;
        Object object = this.tableFactory = tableFactory == null ? new HTableFactory() : tableFactory;
        if (poolType == null) {
            this.poolType = PoolMap.PoolType.Reusable;
        } else {
            switch (poolType) {
                case Reusable: 
                case ThreadLocal: {
                    this.poolType = poolType;
                    break;
                }
                default: {
                    this.poolType = PoolMap.PoolType.Reusable;
                }
            }
        }
        this.tables = new PoolMap(this.poolType, this.maxSize);
        if (this.getCallConnectionValidityCheckMinutes() != null) {
            new ConnectionValidator(this);
        }
    }

    public HTableInterface getTable(String tableName) {
        HTableInterface table = this.findOrCreateTable(tableName);
        return new PooledHTable(table);
    }

    public HTableInterface getTable(byte[] tableName) {
        return this.getTable(Bytes.toString((byte[])tableName));
    }

    public void putTable(HTableInterface table) throws IOException {
        if (!(table instanceof PooledHTable)) {
            throw new IllegalArgumentException("not a pooled table: " + table);
        }
        this.returnTable(((PooledHTable)table).getWrappedTable());
    }

    public void closeTablePool(String tableName) throws IOException {
        Collection tables = this.tables.values((Object)tableName);
        if (tables != null) {
            for (HTableInterface table : tables) {
                this.tableFactory.releaseHTableInterface(table);
            }
        }
        this.tables.remove((Object)tableName);
    }

    public void closeTablePool(byte[] tableName) throws IOException {
        this.closeTablePool(Bytes.toString((byte[])tableName));
    }

    @Override
    public void close() throws IOException {
        for (String tableName : this.tables.keySet()) {
            this.closeTablePool(tableName);
        }
        this.tables.clear();
    }

    int getCurrentPoolSize(String tableName) {
        return this.tables.size((Object)tableName);
    }

    protected HTableInterface findOrCreateTable(String tableName) {
        HTableInterface table = (HTableInterface)this.tables.get((Object)tableName);
        if (table == null) {
            table = this.createHTable(tableName);
        }
        return table;
    }

    protected void returnTable(HTableInterface table) throws IOException {
        String tableName = Bytes.toString((byte[])table.getTableName());
        if (this.tables.size((Object)tableName) >= this.maxSize) {
            this.tables.remove((Object)tableName, (Object)table);
            this.tableFactory.releaseHTableInterface(table);
            return;
        }
        this.tables.put((Object)tableName, (Object)table);
    }

    protected HTableInterface createHTable(String tableName) {
        if (this.getAuthenticationProvider() != null) {
            this.getAuthenticationProvider().authenticatePrincipal(this.config);
        }
        return this.tableFactory.createHTableInterface(this.config, Bytes.toBytes((String)tableName));
    }

    public void setCallConnectionValidityCheckMinutes(Integer callConnectionValidityCheckMinutes) {
        this.callConnectionValidityCheckMinutes = callConnectionValidityCheckMinutes;
    }

    public Integer getCallConnectionValidityCheckMinutes() {
        return this.callConnectionValidityCheckMinutes;
    }

    public void setAuthenticationProvider(AuthenticationProvider authenticationProvider) {
        this.authenticationProvider = authenticationProvider;
    }

    public AuthenticationProvider getAuthenticationProvider() {
        return this.authenticationProvider;
    }

    class ConnectionValidator
    extends Thread {
        HTablePool tablePool;

        ConnectionValidator(HTablePool tablePool) {
            this.tablePool = tablePool;
            this.setPriority(1);
            this.setDaemon(true);
            this.setName("HTablePoolValidator_" + this.tablePool.hashCode());
            this.start();
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(this.tablePool.getCallConnectionValidityCheckMinutes() * 60000);
                        long start = System.currentTimeMillis();
                        LOGGER.debug("Starting to validate connections for tablepool with size : " + this.tablePool.tables.keySet().size());
                        for (String tableName : this.tablePool.tables.keySet()) {
                            HTableInterface table = (HTableInterface)this.tablePool.tables.get((Object)tableName);
                            try {
                                table.exists(new Get(Bytes.toBytes((long)System.currentTimeMillis())));
                            }
                            catch (Exception ex) {
                                LOGGER.info("Error validating connection for : " + tableName + " : " + ex.getMessage() + " . Invalidating all connections for this table.");
                                this.tablePool.closeTablePool(tableName);
                                LOGGER.info("Recreating a single connection for : " + tableName);
                                table = this.tablePool.createHTable(tableName);
                                table.close();
                            }
                        }
                        LOGGER.debug("Completed validating connections. Connections size : " + HTablePool.this.tables.keySet().size() + ". Completed in : " + (System.currentTimeMillis() - start) + " ms");
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error validating pool connections : " + e.getMessage() + ". Will retry in : " + this.tablePool.getCallConnectionValidityCheckMinutes() + " minutes.", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }

    class PooledHTable
    implements HTableInterface {
        private HTableInterface table;

        public PooledHTable(HTableInterface table) {
            this.table = table;
        }

        public byte[] getTableName() {
            return this.table.getTableName();
        }

        public Configuration getConfiguration() {
            return this.table.getConfiguration();
        }

        public HTableDescriptor getTableDescriptor() throws IOException {
            return this.table.getTableDescriptor();
        }

        public boolean exists(Get get) throws IOException {
            return this.table.exists(get);
        }

        public void batch(List<? extends Row> actions, Object[] results) throws IOException, InterruptedException {
            this.table.batch(actions, results);
        }

        public Object[] batch(List<? extends Row> actions) throws IOException, InterruptedException {
            return this.table.batch(actions);
        }

        public Result get(Get get) throws IOException {
            return this.table.get(get);
        }

        public Result[] get(List<Get> gets) throws IOException {
            return this.table.get(gets);
        }

        public Result getRowOrBefore(byte[] row, byte[] family) throws IOException {
            return this.table.getRowOrBefore(row, family);
        }

        public ResultScanner getScanner(Scan scan) throws IOException {
            return this.table.getScanner(scan);
        }

        public ResultScanner getScanner(byte[] family) throws IOException {
            return this.table.getScanner(family);
        }

        public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
            return this.table.getScanner(family, qualifier);
        }

        public void put(Put put) throws IOException {
            this.table.put(put);
        }

        public void put(List<Put> puts) throws IOException {
            this.table.put(puts);
        }

        public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, byte[] value, Put put) throws IOException {
            return this.table.checkAndPut(row, family, qualifier, value, put);
        }

        public void delete(Delete delete) throws IOException {
            this.table.delete(delete);
        }

        public void delete(List<Delete> deletes) throws IOException {
            this.table.delete(deletes);
        }

        public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, byte[] value, Delete delete) throws IOException {
            return this.table.checkAndDelete(row, family, qualifier, value, delete);
        }

        public Result increment(Increment increment) throws IOException {
            return this.table.increment(increment);
        }

        public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) throws IOException {
            return this.table.incrementColumnValue(row, family, qualifier, amount);
        }

        public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, boolean writeToWAL) throws IOException {
            return this.table.incrementColumnValue(row, family, qualifier, amount, writeToWAL);
        }

        public boolean isAutoFlush() {
            return this.table.isAutoFlush();
        }

        public void flushCommits() throws IOException {
            this.table.flushCommits();
        }

        public void close() throws IOException {
            HTablePool.this.returnTable(this.table);
        }

        public RowLock lockRow(byte[] row) throws IOException {
            return this.table.lockRow(row);
        }

        public void unlockRow(RowLock rl) throws IOException {
            this.table.unlockRow(rl);
        }

        public <T extends CoprocessorProtocol> T coprocessorProxy(Class<T> protocol, byte[] row) {
            return (T)this.table.coprocessorProxy(protocol, row);
        }

        public <T extends CoprocessorProtocol, R> Map<byte[], R> coprocessorExec(Class<T> protocol, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable) throws IOException, Throwable {
            return this.table.coprocessorExec(protocol, startKey, endKey, callable);
        }

        public <T extends CoprocessorProtocol, R> void coprocessorExec(Class<T> protocol, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable, Batch.Callback<R> callback) throws IOException, Throwable {
            this.table.coprocessorExec(protocol, startKey, endKey, callable, callback);
        }

        public String toString() {
            return "PooledHTable{, table=" + this.table + '}';
        }

        HTableInterface getWrappedTable() {
            return this.table;
        }

        public void mutateRow(RowMutations rm) throws IOException {
            this.table.mutateRow(rm);
        }

        public Result append(Append append) throws IOException {
            return this.table.append(append);
        }

        public void setAutoFlush(boolean autoFlush) {
            this.table.setAutoFlush(autoFlush);
        }

        public void setAutoFlush(boolean autoFlush, boolean clearBufferOnFail) {
            this.table.setAutoFlush(autoFlush, clearBufferOnFail);
        }

        public long getWriteBufferSize() {
            return this.table.getWriteBufferSize();
        }

        public void setWriteBufferSize(long writeBufferSize) throws IOException {
            this.table.setWriteBufferSize(writeBufferSize);
        }
    }
}

