/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.dataaccess.hbase.auth.kerberos;

import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.zookeeper.Shell;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.trpr.dataaccess.hbase.auth.AuthenticationProvider;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;

public class KerberosAuthenticationProvider
implements AuthenticationProvider,
InitializingBean {
    private static final Logger LOGGER = LogFactory.getLogger(KerberosAuthenticationProvider.class);
    private static final String KERBEROS = "kerberos";
    private static final String KERBEROS_CONFIG_SYSTEM_VARIABLE = "java.security.krb5.conf";
    private static final String HADOOP_KINIT_COMMAND = "hadoop.kerberos.kinit.command";
    private static final String HADOOP_KINIT_COMMAND_DEFAULT = "kinit";
    private static final String HADOOP_KINIT_COMMAND_REFRESH_FLAG = "-R";
    private static final int CALL_TGT_RENEWAL_CHECK_MINUTES = 60;
    private Properties kerberosAuthProperties;
    private String kerberosConfigLocation;
    private String kerberosKeytabLocation;
    private String kerberosPrincipal;
    private int callTGTRenewalCheckMinutes = 60;
    private long lastSuccessfulAuthTimestamp;
    private Thread tgtRenewalThread;

    @Override
    public void authenticatePrincipal(Configuration configuration) throws SecurityException {
        if (System.currentTimeMillis() - (long)(this.callTGTRenewalCheckMinutes * 60000) < this.lastSuccessfulAuthTimestamp) {
            return;
        }
        for (Object key : this.kerberosAuthProperties.keySet()) {
            configuration.set(key.toString(), this.kerberosAuthProperties.getProperty(key.toString()));
        }
        System.setProperty(KERBEROS_CONFIG_SYSTEM_VARIABLE, this.kerberosConfigLocation);
        try {
            UserGroupInformation.setConfiguration((Configuration)configuration);
            UserGroupInformation.loginUserFromKeytab((String)this.kerberosPrincipal, (String)this.kerberosKeytabLocation);
            UserGroupInformation loggedInUser = UserGroupInformation.getLoginUser();
            LOGGER.info("Currently logged in Kerberos principal : " + loggedInUser);
            this.lastSuccessfulAuthTimestamp = System.currentTimeMillis();
            if (this.tgtRenewalThread == null) {
                this.tgtRenewalThread = new TGTRenewalThread(configuration, loggedInUser);
            }
        }
        catch (Exception e) {
            throw new SecurityException("Error authenticating Kerberos Principal : " + this.kerberosPrincipal + " .Error message : " + e.getMessage(), e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.kerberosConfigLocation, (String)"The 'kerberosConfigLocation' may not be null");
        Assert.notNull((Object)this.kerberosKeytabLocation, (String)"The 'kerberosKeytabLocation' may not be null");
        Assert.notNull((Object)this.kerberosPrincipal, (String)"The 'kerberosPrincipal' may not be null");
        Assert.notNull((Object)this.kerberosAuthProperties, (String)"The 'kerberosAuthProperties' may not be null");
        if (this.kerberosAuthProperties.getProperty("hadoop.security.authentication") == null || !this.kerberosAuthProperties.getProperty("hadoop.security.authentication").equalsIgnoreCase(KERBEROS)) {
            throw new SecurityException("Property : hadoop.security.authentication must be of value : kerberos");
        }
    }

    public Properties getKerberosAuthProperties() {
        return this.kerberosAuthProperties;
    }

    public void setKerberosAuthProperties(Properties kerberosAuthProperties) {
        this.kerberosAuthProperties = kerberosAuthProperties;
    }

    public String getKerberosConfigLocation() {
        return this.kerberosConfigLocation;
    }

    public void setKerberosConfigLocation(String kerberosConfigLocation) {
        this.kerberosConfigLocation = kerberosConfigLocation;
    }

    public String getKerberosKeytabLocation() {
        return this.kerberosKeytabLocation;
    }

    public void setKerberosKeytabLocation(String kerberosKeytabLocation) {
        this.kerberosKeytabLocation = kerberosKeytabLocation;
    }

    public String getKerberosPrincipal() {
        return this.kerberosPrincipal;
    }

    public void setKerberosPrincipal(String kerberosPrincipal) {
        this.kerberosPrincipal = kerberosPrincipal;
    }

    public int getCallTGTRenewalCheckMinutes() {
        return this.callTGTRenewalCheckMinutes;
    }

    public void setCallTGTRenewalCheckMinutes(int callTGTRenewalCheckMinutes) {
        this.callTGTRenewalCheckMinutes = callTGTRenewalCheckMinutes;
    }

    class TGTRenewalThread
    extends Thread {
        Configuration configuration;
        UserGroupInformation ugi;

        TGTRenewalThread(Configuration configuration, UserGroupInformation ugi) {
            this.configuration = configuration;
            this.ugi = ugi;
            this.setPriority(1);
            this.setDaemon(true);
            this.setName(ugi.getUserName() + " TGT_Renewer");
            this.start();
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(KerberosAuthenticationProvider.this.getCallTGTRenewalCheckMinutes() * 60000);
                        LOGGER.debug("Try to refresh the Kerberos ticket cache");
                        Shell.execCommand((String[])new String[]{this.configuration.get(KerberosAuthenticationProvider.HADOOP_KINIT_COMMAND, KerberosAuthenticationProvider.HADOOP_KINIT_COMMAND_DEFAULT), KerberosAuthenticationProvider.HADOOP_KINIT_COMMAND_REFRESH_FLAG});
                        KerberosAuthenticationProvider.this.lastSuccessfulAuthTimestamp = System.currentTimeMillis();
                    }
                }
                catch (IOException ioe) {
                    LOGGER.debug("Refresh of Kerberos ticket cache failed with reason : " + ioe.getMessage());
                    try {
                        LOGGER.debug("Check TGT and attempt relogin from Kerberos keytab");
                        this.ugi.checkTGTAndReloginFromKeytab();
                        KerberosAuthenticationProvider.this.lastSuccessfulAuthTimestamp = System.currentTimeMillis();
                    }
                    catch (IOException ie) {
                        LOGGER.error("Error renewing Kerberos TGT for user : " + this.ugi.getUserName(), (Throwable)ie);
                    }
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

