/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.dataaccess.orm.handler;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.trpr.dataaccess.RDBMSHandler;
import org.trpr.platform.core.spi.logging.PerformanceMetricsLogger;
import org.trpr.platform.core.spi.persistence.Criteria;
import org.trpr.platform.core.spi.persistence.DataIntegrityViolationException;
import org.trpr.platform.core.spi.persistence.IncorrectResultSizePersistenceException;
import org.trpr.platform.core.spi.persistence.PersistenceException;
import org.trpr.platform.core.spi.persistence.PersistenceHandler;
import org.trpr.platform.core.spi.persistence.PersistentEntity;

@ManagedResource(objectName="spring.application:type=Trooper,application=Performance-Metrics,name=HibernateMetrics-", description="Hibernate Performance Metrics Logger")
public class HibernateHandler
extends RDBMSHandler {
    private HibernateTemplate template;

    public Collection<PersistentEntity> findEntities(final Criteria criteria) throws PersistenceException {
        this.performanceMetricsLogger.startPerformanceMetricsCapture();
        if (criteria.getQueryType() == 1) {
            return this.findObjectBySQLQuery(criteria);
        }
        Collection results = new LinkedList();
        results = criteria.getMaxResults() > 0 ? (Collection)this.getTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = null;
                query = 2 == criteria.getQueryType() ? session.getNamedQuery(criteria.getQuery()) : session.createQuery(criteria.getQuery());
                query.setFirstResult(criteria.getFirstResult());
                query.setMaxResults(criteria.getMaxResults());
                for (String paramKey : criteria.getParamsMap().keySet()) {
                    if (criteria.getParamsMap().get(paramKey) instanceof Collection) {
                        query.setParameterList(paramKey, (Collection)criteria.getParamsMap().get(paramKey));
                        continue;
                    }
                    if (criteria.getParamsMap().get(paramKey) instanceof Object[]) {
                        query.setParameterList(paramKey, (Object[])criteria.getParamsMap().get(paramKey));
                        continue;
                    }
                    query.setParameter(paramKey, criteria.getParamsMap().get(paramKey));
                }
                List result = query.list();
                return result;
            }
        }) : (2 == criteria.getQueryType() ? this.getTemplate().findByNamedQueryAndNamedParam(criteria.getQuery(), criteria.getParamNamesArray(), criteria.getParamValuesArray()) : this.getTemplate().findByNamedParam(criteria.getQuery(), criteria.getParamNamesArray(), criteria.getParamValuesArray()));
        this.performanceMetricsLogger.logPerformanceMetrics("HibernateHandler.findEntities", criteria.toConciseString());
        return results;
    }

    public PersistentEntity findEntity(Criteria criteria) throws PersistenceException {
        Collection<PersistentEntity> results = this.findEntities(criteria);
        if (results.size() != 1) {
            throw new IncorrectResultSizePersistenceException(1, results.size());
        }
        return (PersistentEntity)((List)results).get(0);
    }

    public PersistentEntity findEntity(PersistentEntity entity) throws PersistenceException {
        if (entity.getIdentifier() != null) {
            this.performanceMetricsLogger.startPerformanceMetricsCapture();
            String message = entity.getEntityName() + ":" + entity.getIdentifier();
            this.getTemplate().load((Object)entity, (Serializable)((Object)entity.getIdentifier().toString()));
            this.performanceMetricsLogger.logPerformanceMetrics("HibernateHandler.findObject", message);
            return entity;
        }
        return this.findEntity(entity.getCriteriaForLoad());
    }

    public PersistentEntity makePersistent(PersistentEntity entity) throws PersistenceException {
        this.performanceMetricsLogger.startPerformanceMetricsCapture();
        try {
            if (entity.getEntityName() != null) {
                this.template.saveOrUpdate(entity.getEntityName(), (Object)entity);
            } else {
                this.template.saveOrUpdate((Object)entity);
            }
        }
        catch (org.springframework.dao.DataIntegrityViolationException die) {
            throw new DataIntegrityViolationException("Data integrity violation for entity:id " + entity.getEntityName() + ":" + entity.getIdentifier().toString(), (Throwable)die);
        }
        catch (DataAccessException de) {
            throw new PersistenceException("Persistence failure for entity:id " + entity.getEntityName() + ":" + entity.getIdentifier().toString(), (Throwable)de);
        }
        catch (Exception e) {
            throw new PersistenceException("Unrecognized/Unhandled Exception while persisting entity:id " + entity.getEntityName() + ":" + entity.getIdentifier().toString(), (Throwable)e);
        }
        finally {
            this.template.clear();
        }
        this.performanceMetricsLogger.logPerformanceMetrics("HibernateHandler.makePersistent", entity.getEntityName() + ":" + entity.getIdentifier().toString());
        return entity;
    }

    public void makeTransient(PersistentEntity entity) throws PersistenceException {
        this.performanceMetricsLogger.startPerformanceMetricsCapture();
        try {
            if (entity.getEntityName() != null) {
                this.template.delete(entity.getEntityName(), (Object)entity);
            } else {
                this.template.delete((Object)entity);
            }
        }
        catch (DataAccessException e) {
            throw new PersistenceException("Delete failure for entity:id " + entity.getEntityName() + ":" + entity.getIdentifier().toString(), (Throwable)e);
        }
        catch (Exception e) {
            throw new PersistenceException("Unrecognized/Unhandled Exception while deleting entity:id " + entity.getEntityName() + ":" + entity.getIdentifier().toString(), (Throwable)e);
        }
        finally {
            this.template.clear();
        }
        this.performanceMetricsLogger.logPerformanceMetrics("HibernateHandler.makeTransient", entity.getEntityName() + ":" + entity.getIdentifier().toString());
    }

    public int update(Criteria criteria) throws PersistenceException {
        this.performanceMetricsLogger.startPerformanceMetricsCapture();
        int result = this.template.bulkUpdate(criteria.getQuery(), criteria.getParamValuesArray());
        this.performanceMetricsLogger.logPerformanceMetrics("HibernateHandler.update", criteria.toConciseString());
        return result;
    }

    public boolean equals(PersistenceHandler persistenceHandler) throws PersistenceException {
        DataSource currentDatasource = SessionFactoryUtils.getDataSource((SessionFactory)this.template.getSessionFactory());
        DataSource otherDatasource = SessionFactoryUtils.getDataSource((SessionFactory)((HibernateHandler)persistenceHandler).getTemplate().getSessionFactory());
        try {
            return currentDatasource.getConnection().getMetaData().getURL().equalsIgnoreCase(otherDatasource.getConnection().getMetaData().getURL());
        }
        catch (SQLException e) {
            throw new PersistenceException("Error evaluating PersistenceHandler#equals() : " + e.getMessage(), (Throwable)e);
        }
    }

    public void setTemplate(HibernateTemplate template) {
        this.template = template;
    }

    public HibernateTemplate getTemplate() {
        return this.template;
    }

    public PerformanceMetricsLogger getPerformanceMetricsLogger() {
        return this.performanceMetricsLogger;
    }

    public void setPerformanceMetricsLogger(PerformanceMetricsLogger performanceMetricsLogger) {
        this.performanceMetricsLogger = performanceMetricsLogger;
    }

    private List<PersistentEntity> findObjectBySQLQuery(final Criteria criteria) {
        return (List)this.getTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                SQLQuery sqlQueryObject = session.createSQLQuery(criteria.getQuery());
                sqlQueryObject.addEntity(criteria.getManagedClass());
                sqlQueryObject.setFirstResult(criteria.getFirstResult());
                if (criteria.getMaxResults() > 0) {
                    sqlQueryObject.setMaxResults(criteria.getMaxResults());
                }
                return sqlQueryObject.list();
            }
        });
    }
}

