/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.example.batch.greeting.reader;

import java.util.Calendar;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.ParseException;
import org.springframework.batch.item.UnexpectedInputException;
import org.trpr.example.model.entity.earthling.Earthling;
import org.trpr.platform.batch.common.BatchException;
import org.trpr.platform.batch.spi.spring.reader.BatchItemStreamReader;

public class GreetingJobReader<T extends Earthling>
implements BatchItemStreamReader<Earthling> {
    private int batchSize;

    public Earthling read() throws Exception, UnexpectedInputException, ParseException {
        throw new BatchException("Operation is not supported! Use the CompositeItemStreamReader#read() method instead.");
    }

    public Earthling[] batchRead(ExecutionContext context) throws Exception, UnexpectedInputException, ParseException {
        int partitionIndex = context.getInt("partitionIndex", -1);
        Earthling[] earthlings = new Earthling[this.getBatchSize()];
        for (int i = 0; i < this.getBatchSize(); ++i) {
            earthlings[i] = new Earthling();
            earthlings[i].setFirstName("Mr");
            earthlings[i].setLastName("Trooper " + partitionIndex);
            Calendar c = Calendar.getInstance();
            c.set(1, 2010);
            earthlings[i].setDateOfBirth(c);
        }
        return earthlings;
    }

    public void close() throws ItemStreamException {
    }

    public void open(ExecutionContext context) throws ItemStreamException {
    }

    public void update(ExecutionContext arg0) throws ItemStreamException {
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }
}

