/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.example.batch.greeting.writer;

import java.util.List;
import org.springframework.batch.item.ItemWriter;
import org.trpr.example.model.entity.earthling.Earthling;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;
import org.trpr.platform.integration.spi.messaging.MessagePublisher;

public class GreetingJobWriter<T extends Earthling>
implements ItemWriter<Earthling> {
    private static final Logger LOGGER = LogFactory.getLogger(GreetingJobWriter.class);
    private MessagePublisher publisher;

    public void write(List<? extends Earthling> earthlings) throws Exception {
        for (Earthling earthling : earthlings) {
            LOGGER.info("Publishing Earthling : " + earthling.getFirstName() + " " + earthling.getLastName() + "; DOB is " + earthling.getDateOfBirth().getTime());
            this.publisher.publish((Object)earthling);
        }
    }

    public MessagePublisher getPublisher() {
        return this.publisher;
    }

    public void setPublisher(MessagePublisher publisher) {
        this.publisher = publisher;
    }
}

