/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.example.seda.cep.mule.transformer;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractTransformer;
import org.trpr.example.model.entity.earthling.Earthling;
import org.trpr.example.model.service.echoservice.EchoServiceRequest;
import org.trpr.platform.servicefw.impl.ServiceRequestImpl;
import org.trpr.platform.servicefw.spi.ServiceRequest;

public class EarthlingToEchoServiceRequestTransformer<T extends EchoServiceRequest>
extends AbstractTransformer {
    private static final String SERVICE_NAME = "echoService";
    private static final String SERVICE_VERSION = "1.0";

    public EarthlingToEchoServiceRequestTransformer() {
        this.registerSourceType(byte[].class);
        this.setReturnClass(ServiceRequest.class);
    }

    public Object doTransform(Object src, String encoding) throws TransformerException {
        EchoServiceRequest echoServiceRequest = new EchoServiceRequest();
        try {
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream((byte[])src));
            Earthling earthling = (Earthling)ois.readObject();
            ois.close();
            echoServiceRequest.setEarthling(earthling);
            echoServiceRequest.setVersion(SERVICE_VERSION);
        }
        catch (Exception e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
        return new ServiceRequestImpl((Object)echoServiceRequest, SERVICE_NAME, echoServiceRequest.getVersion());
    }
}

