/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.example.service.echo;

import org.trpr.example.model.entity.earthling.Earthling;
import org.trpr.example.model.service.echoservice.EchoServiceRequest;
import org.trpr.example.model.service.echoservice.EchoServiceResponse;
import org.trpr.example.service.echo.EchoTask;
import org.trpr.example.service.echo.EchoTaskData;
import org.trpr.platform.service.model.common.status.Status;
import org.trpr.platform.servicefw.impl.AbstractServiceImpl;
import org.trpr.platform.servicefw.impl.ServiceResponseImpl;
import org.trpr.platform.servicefw.spi.ServiceRequest;
import org.trpr.platform.servicefw.spi.ServiceResponse;
import org.trpr.platform.spi.task.Resource;
import org.trpr.platform.spi.task.TaskContext;

public class EchoService
extends AbstractServiceImpl<EchoServiceRequest, EchoServiceResponse> {
    private static final String ECHO_TASK_ID = "echotask";

    protected EchoTask[] getAllTasks(ServiceRequest<EchoServiceRequest> request) {
        EchoTask echoTask = new EchoTask(new EchoTaskData<Earthling, Resource>(((EchoServiceRequest)request.getRequestData()).getEarthling()), ECHO_TASK_ID);
        return new EchoTask[]{echoTask};
    }

    protected ServiceResponse prepareServiceResponse(TaskContext taskContext, ServiceRequest serviceRequest) {
        EchoServiceRequest echoServiceRequest = (EchoServiceRequest)serviceRequest.getRequestData();
        EchoServiceResponse echoServiceResponse = new EchoServiceResponse();
        Earthling earthling = echoServiceRequest.getEarthling();
        String echo = "Echo " + earthling.getFirstName() + " " + earthling.getLastName() + " " + earthling.getDateOfBirth().getTime();
        echoServiceResponse.setEcho(echo);
        this.populateStatus(true, echoServiceResponse);
        ServiceResponseImpl serviceResponse = new ServiceResponseImpl(String.valueOf(1));
        serviceResponse.setResponseData((Object)echoServiceResponse);
        return serviceResponse;
    }

    private void populateStatus(boolean success, EchoServiceResponse echoPersonServiceResponse) {
        Status status = new Status();
        status.setCode(success ? 1 : 0);
        status.setMessage(success ? "SUCCESS" : "FAILURE");
        echoPersonServiceResponse.setStatus(status);
    }
}

