/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.example.service.greeting;

import org.trpr.example.model.entity.earthling.Earthling;
import org.trpr.platform.impl.validation.AbstractBusinessEntityValidationStrategy;
import org.trpr.platform.model.common.BusinessEntity;
import org.trpr.platform.spi.execution.ResultCode;
import org.trpr.platform.spi.execution.Severity;
import org.trpr.platform.spi.validation.ValidationSummary;

public class GreetingValidationStrategy
extends AbstractBusinessEntityValidationStrategy {
    public GreetingValidationStrategy(Earthling earthling) {
        super((BusinessEntity)earthling);
    }

    protected ValidationSummary validate() {
        super.validate("firstName.length() < 10", (ResultCode)GreetingResult.INVALID_FIRST_NAME, null);
        super.validate("lastName.length() < 10", (ResultCode)GreetingResult.INVALID_LAST_NAME, null);
        super.validate("dateOfBirth.before(Calendar.getInstance())", (ResultCode)GreetingResult.INVALID_DATE_OF_BIRTH, null);
        return super.getValidationResults();
    }

    public static enum GreetingResult implements ResultCode
    {
        INVALID_FIRST_NAME(101, "First name should not exceed 10 characters", Severity.ERROR),
        INVALID_LAST_NAME(102, "Last name should not exceed 10 characters", Severity.ERROR),
        INVALID_DATE_OF_BIRTH(103, "Date of birth cannot be later than current date", Severity.ERROR);

        private int code;
        private String message;
        private Severity severity;

        private GreetingResult(int code, String message, Severity severity) {
            this.code = code;
            this.message = message;
            this.severity = severity;
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        public Severity getSeverity() {
            return this.severity;
        }
    }
}

