/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.example.service.greeting;

import org.trpr.example.model.entity.earthling.Earthling;
import org.trpr.example.model.service.greetingservice.GreetingServiceRequest;
import org.trpr.example.model.service.greetingservice.GreetingServiceResponse;
import org.trpr.example.service.greeting.GreetingValidationStrategy;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;
import org.trpr.platform.model.common.BusinessEntity;
import org.trpr.platform.service.model.common.platformservicerequest.PlatformServiceRequest;
import org.trpr.platform.service.model.common.platformserviceresponse.PlatformServiceResponse;
import org.trpr.platform.service.model.common.status.Status;
import org.trpr.platform.servicefw.impl.ServiceResponseImpl;
import org.trpr.platform.servicefw.impl.SimpleAbstractServiceImpl;
import org.trpr.platform.servicefw.impl.validation.ValidationServiceResponseGenerator;
import org.trpr.platform.servicefw.spi.ServiceRequest;
import org.trpr.platform.servicefw.spi.ServiceResponse;
import org.trpr.platform.spi.validation.ValidationSummary;

public class SimpleGreetingService
extends SimpleAbstractServiceImpl<GreetingServiceRequest, GreetingServiceResponse> {
    private static final Logger LOGGER = LogFactory.getLogger(SimpleGreetingService.class);

    protected ServiceResponse<GreetingServiceResponse> processRequestInternal(ServiceRequest<GreetingServiceRequest> serviceRequest) {
        GreetingServiceRequest greetingServiceRequest = (GreetingServiceRequest)serviceRequest.getRequestData();
        GreetingServiceResponse greetingServiceResponse = new GreetingServiceResponse();
        Earthling earthling = ((GreetingServiceRequest)serviceRequest.getRequestData()).getEarthling();
        GreetingValidationStrategy greetingValidationStrategy = new GreetingValidationStrategy(earthling);
        ValidationSummary validationSummary = greetingValidationStrategy.validate();
        if (validationSummary.hasValidationErrors()) {
            LOGGER.info("**** SimpleGreetingService execution : FAILURE ****");
            ValidationServiceResponseGenerator responseGenerator = new ValidationServiceResponseGenerator((BusinessEntity)earthling);
            return responseGenerator.populateResponseFromValidationResults(validationSummary, (PlatformServiceResponse)greetingServiceResponse, (PlatformServiceRequest)greetingServiceRequest);
        }
        String header = "Hello: " + earthling.getFirstName() + " " + earthling.getLastName() + "; Your date of birth is " + earthling.getDateOfBirth().getTime();
        greetingServiceResponse.setHeader(header);
        LOGGER.debug("**** SimpleGreetingService execution : SUCCESS ****");
        LOGGER.info(header);
        this.populateStatus(true, greetingServiceResponse);
        greetingServiceResponse.setPlatformServiceRequest((PlatformServiceRequest)greetingServiceRequest);
        ServiceResponseImpl serviceResponse = new ServiceResponseImpl(String.valueOf(1));
        serviceResponse.setResponseData((Object)greetingServiceResponse);
        return serviceResponse;
    }

    private void populateStatus(boolean success, GreetingServiceResponse greetingServiceResponse) {
        Status status = new Status();
        status.setCode(success ? 1 : 0);
        status.setMessage(success ? "SUCCESS" : "FAILURE");
        greetingServiceResponse.setStatus(status);
    }
}

