/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.integration.impl.messaging;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.QueueingConsumer;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.util.HashMap;
import org.trpr.platform.core.impl.logging.LogFactory;
import org.trpr.platform.core.spi.logging.Logger;
import org.trpr.platform.integration.impl.messaging.RabbitMQConfiguration;
import org.trpr.platform.integration.impl.messaging.RabbitMQRpcConfiguration;
import org.trpr.platform.integration.spi.messaging.MessagingException;

public class RabbitConnectionHolder
implements ShutdownListener {
    private static final Logger LOGGER = LogFactory.getLogger(RabbitConnectionHolder.class);
    private Connection conn;
    private Channel channel;
    private QueueingConsumer consumer;
    private String rpcReplyToQueueName;
    private RabbitMQConfiguration rabbitMQConfiguration;
    private RabbitMQRpcConfiguration rabbitMQRpcConfiguration;

    public RabbitConnectionHolder(RabbitMQConfiguration rabbitMQConfiguration) {
        this.rabbitMQConfiguration = rabbitMQConfiguration;
    }

    public RabbitConnectionHolder(RabbitMQRpcConfiguration rabbitMQRpcConfiguration) {
        this.rabbitMQRpcConfiguration = rabbitMQRpcConfiguration;
    }

    public void createConnection() throws MessagingException {
        this.createConnection(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createConnection(boolean disableTX) throws MessagingException {
        String dlQueue = null;
        String dlExchange = null;
        if (this.rabbitMQRpcConfiguration != null) {
            this.createRPCConnection(this.rabbitMQRpcConfiguration);
            return;
        }
        if (this.rabbitMQConfiguration != null) {
            this.createConnection(this.rabbitMQConfiguration);
            RabbitConnectionHolder rabbitConnectionHolder = this;
            synchronized (rabbitConnectionHolder) {
                try {
                    this.channel.basicQos(1);
                    if (this.rabbitMQConfiguration.isDurable() && !this.rabbitMQConfiguration.isDisableTX() && !disableTX) {
                        this.channel.txSelect();
                    }
                    if (this.rabbitMQConfiguration.isDlqEnabled()) {
                        dlQueue = String.valueOf(this.rabbitMQConfiguration.getQueueName()) + ".dead";
                        dlExchange = String.valueOf(this.rabbitMQConfiguration.getExchangeName()) + ".dead";
                        HashMap<String, String> args = new HashMap<String, String>();
                        args.put("x-dead-letter-exchange", dlExchange);
                        args.put("x-dead-letter-routing-key", this.rabbitMQConfiguration.getRoutingKey());
                        this.channel.queueDeclare(dlQueue, this.rabbitMQConfiguration.isDurable(), false, false, null);
                        this.channel.queueDeclare(this.rabbitMQConfiguration.getQueueName(), this.rabbitMQConfiguration.isDurable(), false, false, args);
                        this.channel.queueBind(dlQueue, dlExchange, this.rabbitMQConfiguration.getRoutingKey());
                    } else {
                        this.channel.queueDeclare(this.rabbitMQConfiguration.getQueueName(), this.rabbitMQConfiguration.isDurable(), false, false, null);
                    }
                    this.channel.queueBind(this.rabbitMQConfiguration.getQueueName(), this.rabbitMQConfiguration.getExchangeName(), this.rabbitMQConfiguration.getRoutingKey());
                }
                catch (Exception e) {
                    LOGGER.error("Error initializing RabbitMQ connection : " + e.getMessage() + this.rabbitMQConfiguration.toString(), (Throwable)e);
                    throw new MessagingException("Error initializing RabbitMQ connection : " + e.getMessage());
                }
            }
        }
        LOGGER.info("Connection created for configuration : " + this.rabbitMQConfiguration.toString());
    }

    public void createConnectionAndConsumer() throws MessagingException {
        this.createConnection(true);
        this.createConsumer();
    }

    public void createConsumer() throws MessagingException {
        if (this.rabbitMQRpcConfiguration != null) {
            this.setupReplyQueue(this.rabbitMQRpcConfiguration);
            this.createConsumer(this.rabbitMQRpcConfiguration, this.rpcReplyToQueueName, true);
            return;
        }
        if (this.rabbitMQConfiguration != null) {
            this.createConsumer(this.rabbitMQConfiguration, this.rabbitMQConfiguration.getQueueName(), this.rabbitMQConfiguration.isNoAck());
        }
    }

    public Channel getChannel() {
        return this.channel;
    }

    public String getConsumerQueueName() {
        return this.rabbitMQRpcConfiguration != null ? this.rpcReplyToQueueName : this.rabbitMQConfiguration.getQueueName();
    }

    public int getMessageCount() throws Exception {
        try {
            if (this.rabbitMQConfiguration.isDlqEnabled()) {
                String dlQueue = null;
                String dlExchange = null;
                dlQueue = String.valueOf(this.rabbitMQConfiguration.getQueueName()) + ".dead";
                dlExchange = String.valueOf(this.rabbitMQConfiguration.getExchangeName()) + ".dead";
                HashMap<String, String> args = new HashMap<String, String>();
                args.put("x-dead-letter-exchange", dlExchange);
                args.put("x-dead-letter-routing-key", this.rabbitMQConfiguration.getRoutingKey());
                this.channel.queueDeclare(dlQueue, this.rabbitMQConfiguration.isDurable(), false, false, null);
                return this.channel.queueDeclare(this.rabbitMQConfiguration.getQueueName(), this.rabbitMQConfiguration.isDurable(), false, false, args).getMessageCount();
            }
            return this.channel.queueDeclare(this.rabbitMQConfiguration.getQueueName(), this.rabbitMQConfiguration.isDurable(), false, false, null).getMessageCount();
        }
        catch (IOException e) {
            LOGGER.error("Error retrieving message count for queue. Returning 0. Configuration is : " + this.rabbitMQConfiguration);
            return 0;
        }
    }

    public QueueingConsumer getConsumer() {
        return this.consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection() throws MessagingException {
        try {
            RabbitConnectionHolder rabbitConnectionHolder = this;
            synchronized (rabbitConnectionHolder) {
                if (this.consumer != null) {
                    this.channel.basicCancel(this.consumer.getConsumerTag());
                    this.consumer = null;
                }
                if (this.channel != null) {
                    this.channel.close();
                    this.channel = null;
                }
                if (this.conn != null) {
                    this.conn.close();
                    this.conn = null;
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Error while closing resources for : " + this.rabbitMQConfiguration.toString(), (Throwable)e);
            throw new MessagingException("Error while closing resources for : " + this.rabbitMQConfiguration.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownCompleted(ShutdownSignalException sse) {
        LOGGER.info("Connection terminated for configuration : " + this.rabbitMQConfiguration.toString());
        RabbitConnectionHolder rabbitConnectionHolder = this;
        synchronized (rabbitConnectionHolder) {
            this.conn = null;
            this.channel = null;
            this.consumer = null;
        }
    }

    public boolean isValid() {
        return this.conn != null && this.channel != null;
    }

    private void createConnection(RabbitMQConfiguration configuration) throws MessagingException {
        this.createRPCConnection(configuration);
        if (this.rabbitMQConfiguration.isDlqEnabled()) {
            try {
                this.channel.exchangeDeclare(String.valueOf(configuration.getExchangeName()) + ".dead", configuration.getExchangeType(), configuration.isDurable());
            }
            catch (Exception e) {
                LOGGER.error("Error initializing RabbitMQ connection for : " + configuration.toString(), (Throwable)e);
                throw new MessagingException("Error initializing RabbitMQ connection for : " + configuration.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRPCConnection(RabbitMQRpcConfiguration configuration) throws MessagingException {
        RabbitConnectionHolder rabbitConnectionHolder = this;
        synchronized (rabbitConnectionHolder) {
            ConnectionFactory factory = new ConnectionFactory();
            factory.setUsername(configuration.getUserName());
            factory.setPassword(configuration.getPassword());
            factory.setVirtualHost(configuration.getVirtualHost());
            factory.setRequestedHeartbeat(configuration.getRequestHeartBeat());
            factory.setHost(configuration.getHostName());
            factory.setPort(configuration.getPortNumber());
            try {
                this.conn = factory.newConnection();
                this.conn.addShutdownListener((ShutdownListener)this);
                this.channel = this.conn.createChannel();
                this.channel.exchangeDeclare(configuration.getExchangeName(), configuration.getExchangeType(), configuration.isDurable());
            }
            catch (Exception e) {
                LOGGER.error("Error initializing RabbitMQ connection for : " + configuration.toString(), (Throwable)e);
                throw new MessagingException("Error initializing RabbitMQ connection for : " + configuration.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createConsumer(RabbitMQRpcConfiguration rabbitMQRpcConfiguration, String queueName, boolean noAck) {
        RabbitConnectionHolder rabbitConnectionHolder = this;
        synchronized (rabbitConnectionHolder) {
            if (this.getChannel() == null) {
                throw new MessagingException("Attempt to create Consumer before calling RabbitConnectionHolder#createConnection(). Consumer will not be created.");
            }
            this.consumer = new QueueingConsumer(this.getChannel());
            try {
                this.getChannel().basicConsume(queueName, noAck, (Consumer)this.consumer);
            }
            catch (IOException ioe) {
                LOGGER.error("Error setting up consumer on channel for : " + rabbitMQRpcConfiguration.toString(), (Throwable)ioe);
                throw new MessagingException("Error setting up consumer on channel for : " + rabbitMQRpcConfiguration.toString());
            }
        }
    }

    private void setupReplyQueue(RabbitMQRpcConfiguration rabbitMQRpcConfiguration) throws MessagingException {
        try {
            this.rpcReplyToQueueName = this.getChannel().queueDeclare("", false, true, true, null).getQueue();
        }
        catch (IOException ioe) {
            LOGGER.error("Error setting up RPC reply queue on channel for : " + rabbitMQRpcConfiguration.toString(), (Throwable)ioe);
            throw new MessagingException("Error setting up RPC reply queue on channel for : " + rabbitMQRpcConfiguration.toString());
        }
    }
}

