/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.integration.impl.xml;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;
import org.trpr.platform.integration.spi.xml.XMLDataException;
import org.trpr.platform.integration.spi.xml.XMLTranscoder;

public class XMLTranscoderImpl
implements XMLTranscoder {
    private static final Map<String, Object> DEFAULT_MARSHALLER_PROPS = new HashMap<String, Object>();
    private Jaxb2Marshaller defaultMarshaller;
    private Jaxb2Marshaller defaultUnmarshaller;
    private org.springframework.oxm.Marshaller marshaller;
    private org.springframework.oxm.Unmarshaller unmarshaller;

    static {
        DEFAULT_MARSHALLER_PROPS.put("jaxb.formatted.output", Boolean.TRUE);
    }

    public XMLTranscoderImpl() {
        this.defaultUnmarshaller = this.defaultMarshaller = new Jaxb2Marshaller();
        this.marshaller = this.defaultMarshaller;
        this.unmarshaller = this.defaultUnmarshaller;
    }

    @Override
    public String marshal(Object object) throws XMLDataException {
        StringWriter stringWriter = new StringWriter();
        this.marshalToResult(object, new StreamResult(stringWriter));
        try {
            stringWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    @Override
    public void marshal(Object object, Result result) throws XMLDataException {
        this.marshalToResult(object, result);
    }

    @Override
    public <T> T unmarshal(String xml, Class<T> clazz) throws XMLDataException {
        StringReader stringReader = new StringReader(xml);
        try {
            if (this.getUnmarshaller() == this.defaultUnmarshaller) {
                this.defaultUnmarshaller.setContextPath(clazz.getPackage().getName());
                this.defaultUnmarshaller.afterPropertiesSet();
            }
            Object object = this.getUnmarshaller().unmarshal((Source)new StreamSource(stringReader));
            return (T)object;
        }
        catch (Exception e) {
            throw new XMLDataException("Error unmarshalling XML. XML:packageName is " + xml + ":" + clazz.getPackage().getName(), e);
        }
        finally {
            stringReader.close();
        }
    }

    public org.springframework.oxm.Marshaller getMarshaller() {
        return this.marshaller;
    }

    public void setMarshaller(org.springframework.oxm.Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public org.springframework.oxm.Unmarshaller getUnmarshaller() {
        return this.unmarshaller;
    }

    public void setUnmarhaller(org.springframework.oxm.Unmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
    }

    private void marshalToResult(Object object, Result result) throws XMLDataException {
        try {
            if (this.getMarshaller() == this.defaultMarshaller) {
                this.defaultMarshaller.setMarshallerProperties(DEFAULT_MARSHALLER_PROPS);
                this.defaultMarshaller.setContextPath(object.getClass().getPackage().getName());
                this.defaultMarshaller.afterPropertiesSet();
            }
            this.getMarshaller().marshal(object, result);
        }
        catch (Exception e) {
            throw new XMLDataException("Error marshalling Object of type : " + object.getClass().getName(), e);
        }
    }

    private String marshalUsingJAXB(Object object) throws XMLDataException {
        try {
            StringWriter stringWriter = new StringWriter();
            JAXBContext context = JAXBContext.newInstance((String)object.getClass().getPackage().getName());
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal(object, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (JAXBException e) {
            throw new XMLDataException("Error marshalling Object of type : " + object.getClass().getName(), e);
        }
    }

    private <T> T unmarshalUsingJAXB(String xml, Class<T> clazz) throws XMLDataException {
        try {
            JAXBContext context = JAXBContext.newInstance((String)clazz.getPackage().getName());
            Unmarshaller unmarshaller = context.createUnmarshaller();
            return (T)unmarshaller.unmarshal((Reader)new StringReader(xml));
        }
        catch (JAXBException e) {
            throw new XMLDataException("Error unmarshalling XML. XML:packageName is " + xml + ":" + clazz.getPackage().getName(), e);
        }
    }
}

