/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.integration.impl.xml;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.trpr.platform.integration.spi.xml.XMLDataException;
import org.trpr.platform.integration.spi.xml.XMLValidator;
import org.trpr.platform.spi.execution.ExecutionResult;
import org.trpr.platform.spi.execution.Severity;
import org.trpr.platform.spi.validation.ValidationResult;
import org.trpr.platform.spi.validation.ValidationSummary;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLValidatorImpl
implements XMLValidator {
    @Override
    public ValidationSummary validate(InputSource input, Schema schema) throws XMLDataException {
        ValidationSummary summary = new ValidationSummary();
        Validator validator = schema.newValidator();
        try {
            validator.validate(new SAXSource(input));
        }
        catch (SAXException e) {
            ValidationResult result = new ValidationResult();
            result.setSeverity(Severity.ERROR);
            result.setMessage(e.getMessage());
            summary.addResult((ExecutionResult)result);
        }
        catch (IOException e) {
            throw new XMLDataException("Error during validation (Unable to read XML)", e);
        }
        return summary;
    }

    @Override
    public ValidationSummary validate(InputSource input, File schema) throws XMLDataException {
        try {
            return this.validate(input, SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schema));
        }
        catch (SAXException e) {
            throw new XMLDataException("Error during validation (Unable to read schema) ", e);
        }
    }

    @Override
    public ValidationSummary validate(String input, Schema schema) throws XMLDataException {
        return this.validate(new InputSource(new ByteArrayInputStream(input.getBytes())), schema);
    }

    @Override
    public ValidationSummary validate(String input, File schema) throws XMLDataException {
        try {
            return this.validate(new InputSource(new ByteArrayInputStream(input.getBytes())), SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schema));
        }
        catch (SAXException e) {
            throw new XMLDataException("Error during validation (Unable to read schema) ", e);
        }
    }

    @Override
    public ValidationSummary validate(String input, Source schema) throws XMLDataException {
        try {
            return this.validate(input, SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schema));
        }
        catch (SAXException e) {
            throw new XMLDataException("Error during validation (Unable to read schema) ", e);
        }
    }

    @Override
    public ValidationSummary validate(String input, Source[] schema) throws XMLDataException {
        try {
            return this.validate(input, SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schema));
        }
        catch (SAXException e) {
            throw new XMLDataException("Error during validation (Unable to read schema) ", e);
        }
    }

    @Override
    public ValidationSummary validate(InputSource input, Source[] schema) throws XMLDataException {
        try {
            return this.validate(input, SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schema));
        }
        catch (SAXException e) {
            throw new XMLDataException("Error during validation (Unable to read schema) ", e);
        }
    }

    @Override
    public Schema getSchemaFromSource(Source[] schema) throws XMLDataException {
        try {
            return SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schema);
        }
        catch (SAXException e) {
            throw new XMLDataException("Error while creating the Schema object from a set of Source xsd's", e);
        }
    }
}

