/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.integration.impl.email;

import java.net.URL;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.mail.javamail.MimeMessagePreparator;
import org.trpr.platform.integration.spi.email.MailSender;

public class SpringMailSender
implements MailSender {
    private JavaMailSender mailSender;

    @Override
    public void sendMail(final String senderAddress, final String subject, final String[] recipients, final String message, final URL attachmentURL) {
        MimeMessagePreparator preparator = new MimeMessagePreparator(){

            public void prepare(MimeMessage mimeMessage) throws Exception {
                InternetAddress[] recipientAddresses = new InternetAddress[recipients.length];
                int i = 0;
                while (i < recipientAddresses.length) {
                    recipientAddresses[i] = new InternetAddress(recipients[i]);
                    ++i;
                }
                mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])recipientAddresses);
                mimeMessage.setFrom((Address)new InternetAddress(senderAddress));
                mimeMessage.setSubject(subject);
                MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, true);
                if (attachmentURL != null) {
                    helper.addAttachment(attachmentURL.getFile(), (InputStreamSource)new FileSystemResource(attachmentURL.toString()));
                }
                helper.setText(message);
            }
        };
        this.mailSender.send(preparator);
    }

    public JavaMailSender getMailSender() {
        return this.mailSender;
    }

    public void setMailSender(JavaMailSender mailSender) {
        this.mailSender = mailSender;
    }
}

