/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.spi.task;

import java.util.LinkedList;
import java.util.List;
import org.springframework.util.StringUtils;
import org.trpr.platform.model.common.BusinessEntity;
import org.trpr.platform.spi.task.Resource;

public abstract class TaskData<T extends BusinessEntity, S extends Resource> {
    private List<T> entitiesList = new LinkedList<T>();
    private List<S> resourcesList = new LinkedList<S>();

    public void addEntity(T ... entities) {
        T[] TArray = entities;
        int n = entities.length;
        int n2 = 0;
        while (n2 < n) {
            T entity;
            entity.setEntityName(StringUtils.hasLength((String)(entity = TArray[n2]).getEntityName()) ? entity.getEntityName() : entity.getClass().getName());
            this.entitiesList.add(entity);
            ++n2;
        }
    }

    public void addResource(S ... resources) {
        S[] SArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            S resource = SArray[n2];
            this.resourcesList.add(resource);
            ++n2;
        }
    }

    public T[] getEntityByName(String name) {
        LinkedList<BusinessEntity> returnEntitiesList = new LinkedList<BusinessEntity>();
        for (BusinessEntity entity : this.entitiesList) {
            if (!entity.getEntityName().equals(name)) continue;
            returnEntitiesList.add(entity);
        }
        return returnEntitiesList.toArray(new BusinessEntity[0]);
    }

    public S[] getResourceByName(String name) {
        LinkedList<Resource> returnResourcesList = new LinkedList<Resource>();
        for (Resource resource : this.resourcesList) {
            if (!resource.getName().equals(name)) continue;
            returnResourcesList.add(resource);
        }
        return returnResourcesList.toArray(new Resource[0]);
    }
}

