/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.spi.execution;

import java.util.Date;
import org.trpr.platform.core.util.DateUtils;
import org.trpr.platform.spi.execution.ResultCode;
import org.trpr.platform.spi.execution.Severity;

public class ExecutionResult {
    private Severity severity = Severity.ERROR;
    private int resultCode;
    private String codeName;
    private ResultCode result;
    private String message;
    private String label;
    private Date createdTime = DateUtils.getCurrentTime();

    public ExecutionResult() {
    }

    public ExecutionResult(Severity severity) {
        this.severity = severity;
    }

    public ExecutionResult(String message) {
        this.message = message;
    }

    public ExecutionResult(ResultCode result) {
        this.result = result;
        this.severity = result.getSeverity();
        this.resultCode = result.getCode();
        this.codeName = result.toString();
        this.message = result.getMessage();
    }

    public ExecutionResult(ResultCode result, String message) {
        this.result = result;
        this.severity = result.getSeverity();
        this.resultCode = result.getCode();
        this.codeName = result.toString();
        this.message = message;
    }

    public ExecutionResult(Severity severity, ResultCode result) {
        this.severity = severity;
        this.result = result;
        this.resultCode = result.getCode();
        this.codeName = result.toString();
        this.message = result.getMessage();
    }

    public ExecutionResult(Severity severity, ResultCode result, String message, String label) {
        this.severity = severity;
        this.result = result;
        this.resultCode = result.getCode();
        this.codeName = result.toString();
        this.message = message;
        this.label = label;
    }

    public boolean equals(Object object) {
        boolean equal = super.equals(object);
        if (!equal) {
            ExecutionResult result = (ExecutionResult)object;
            return this.severity == result.getSeverity() && this.resultCode == result.getResultCode() && this.label.equalsIgnoreCase(result.getLabel());
        }
        return equal;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    public int getResultCode() {
        return this.resultCode;
    }

    public ResultCode getResult() {
        return this.result;
    }

    public void setResultCode(int resultCode) {
        this.resultCode = resultCode;
    }

    public String getCodeName() {
        return this.codeName;
    }

    public void setCodeName(String codeName) {
        this.codeName = codeName;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public int hashCode() {
        return this.severity.hashCode() + this.resultCode;
    }
}

