/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.spi.execution;

import java.util.LinkedList;
import java.util.List;
import org.trpr.platform.spi.execution.ExecutionResult;
import org.trpr.platform.spi.execution.ResultCode;
import org.trpr.platform.spi.execution.Severity;

public class ExecutionSummary {
    protected List<ExecutionResult> results = new LinkedList<ExecutionResult>();

    public ExecutionSummary addResult(ExecutionResult result) {
        this.results.add(result);
        return this;
    }

    public ExecutionSummary addResults(ExecutionResult[] results) {
        ExecutionResult[] executionResultArray = results;
        int n = results.length;
        int n2 = 0;
        while (n2 < n) {
            ExecutionResult result = executionResultArray[n2];
            this.addResult(result);
            ++n2;
        }
        return this;
    }

    public void removeResult(ExecutionResult result) {
        this.results.remove(result);
    }

    public void removeAllResults() {
        this.results.clear();
    }

    public boolean isExecutionSuccess() {
        if (this.results.isEmpty()) {
            return true;
        }
        return !this.hasExecutionErrors();
    }

    public boolean hasExecutionErrors() {
        for (ExecutionResult result : this.results) {
            if (result.getSeverity().getCode() < Severity.ERROR.getCode()) continue;
            return true;
        }
        return false;
    }

    public boolean hasFatalExecutionErrors() {
        for (ExecutionResult result : this.results) {
            if (result.getSeverity() != Severity.FATAL) continue;
            return true;
        }
        return false;
    }

    public ExecutionResult[] getAllResults() {
        return this.results.toArray(new ExecutionResult[0]);
    }

    public ExecutionResult[] getResultsBySeverity(Severity severity) {
        LinkedList<ExecutionResult> list = new LinkedList<ExecutionResult>();
        for (ExecutionResult result : this.results) {
            if (result.getSeverity() != severity) continue;
            list.add(result);
        }
        return list.toArray(new ExecutionResult[0]);
    }

    public boolean hasThisExecutionResult(ResultCode rCode) {
        for (ExecutionResult result : this.results) {
            if (!result.getCodeName().equalsIgnoreCase(rCode.toString())) continue;
            return true;
        }
        return false;
    }
}

