/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.spi.task;

import java.util.LinkedList;
import java.util.List;
import org.trpr.platform.model.common.BusinessEntity;
import org.trpr.platform.spi.execution.ExecutionSummary;
import org.trpr.platform.spi.execution.ResultCode;
import org.trpr.platform.spi.execution.Severity;

public class TaskResult<T extends BusinessEntity> {
    private TaskResultCode resultCode;
    private ExecutionSummary executionSummary;
    private List<T> entitiesList = new LinkedList<T>();

    public void addEntity(T ... entities) {
        T[] TArray = entities;
        int n = entities.length;
        int n2 = 0;
        while (n2 < n) {
            T entity = TArray[n2];
            this.entitiesList.add(entity);
            ++n2;
        }
    }

    public T[] getEntityByName(String name) {
        LinkedList<BusinessEntity> returnEntitiesList = new LinkedList<BusinessEntity>();
        for (BusinessEntity entity : this.entitiesList) {
            if (!entity.getEntityName().equals(name)) continue;
            returnEntitiesList.add(entity);
        }
        return returnEntitiesList.toArray(new BusinessEntity[0]);
    }

    public TaskResultCode getResultCode() {
        return this.resultCode;
    }

    public ExecutionSummary getExecutionSummary() {
        return this.executionSummary;
    }

    public void setExecutionSummary(ExecutionSummary executionSummary) {
        this.executionSummary = executionSummary;
    }

    public void setResultCode(TaskResultCode resultCode) {
        this.resultCode = resultCode;
    }

    public static enum TaskResultCode implements ResultCode
    {
        SUCCESS(100, "Task execution success", Severity.INFO),
        FAILURE(101, "Task execution failure", Severity.INFO),
        FAILURE_FATAL(102, "Task execution fatal failure", Severity.INFO),
        FAILURE_RETRY(103, "Task execution failure. Retry", Severity.INFO);

        private int code;
        private String message;
        private Severity severity;

        private TaskResultCode(int code, String message, Severity severity) {
            this.code = code;
            this.message = message;
            this.severity = severity;
        }

        @Override
        public int getCode() {
            return this.code;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public Severity getSeverity() {
            return this.severity;
        }
    }
}

