/*
 * Decompiled with CFR 0.152.
 */
package org.trpr.platform.impl.validation;

import org.trpr.platform.impl.validation.ExpressionBasedValidator;
import org.trpr.platform.model.common.BusinessEntity;
import org.trpr.platform.spi.execution.ExecutionResult;
import org.trpr.platform.spi.execution.ResultCode;
import org.trpr.platform.spi.execution.Severity;
import org.trpr.platform.spi.validation.BusinessEntityValidationStrategy;
import org.trpr.platform.spi.validation.ValidationSummary;

public abstract class AbstractBusinessEntityValidationStrategy
implements BusinessEntityValidationStrategy {
    private static final String[] MVEL_PROPERTY_BOUNDARY_START = new String[]{".", "["};
    private ExpressionBasedValidator validator = new ExpressionBasedValidator();
    protected ValidationSummary validationSummary = new ValidationSummary();
    protected BusinessEntity entity;

    public AbstractBusinessEntityValidationStrategy() {
    }

    public AbstractBusinessEntityValidationStrategy(BusinessEntity entity) {
        this.entity = entity;
    }

    public void setValidator(ExpressionBasedValidator validator) {
        this.validator = validator;
    }

    @Override
    public ValidationSummary validate(BusinessEntity entity) {
        this.entity = entity;
        return this.validate();
    }

    protected abstract ValidationSummary validate();

    protected ValidationSummary getValidationResults() {
        return this.validationSummary;
    }

    protected void validate(String mvelExpression, ResultCode result) {
        this.checkAndValidate(mvelExpression, result, 0, null, null, null);
    }

    protected void validate(String mvelExpression, ResultCode resultCode, String defaultMessage) {
        this.validate(mvelExpression, resultCode, 0, defaultMessage);
    }

    protected void validate(String mvelExpression, ResultCode resultCode, String messageId, String defaultMessage) {
        this.validate(mvelExpression, resultCode, 0, messageId, defaultMessage);
    }

    protected void validate(String mvelExpression, ResultCode resultCode, String messageId, String defaultMessage, String label) {
        this.validate(mvelExpression, resultCode, 0, messageId, defaultMessage, label);
    }

    protected void vetoValidate(String mvelExpression, ResultCode resultCode) {
        this.validate(mvelExpression, resultCode, 100);
    }

    protected void vetoValidate(String mvelExpression, ResultCode resultCode, String defaultMessage) {
        this.validate(mvelExpression, resultCode, 100, defaultMessage);
    }

    protected void vetoValidate(String mvelExpression, ResultCode resultCode, String messageId, String defaultMessage) {
        this.validate(mvelExpression, resultCode, 100, messageId, defaultMessage);
    }

    protected void vetoValidate(String mvelExpression, ResultCode resultCode, String messageId, String defaultMessage, String label) {
        this.validate(mvelExpression, resultCode, 100, messageId, defaultMessage, label);
    }

    private void validate(String mvelExpression, ResultCode resultCode, int validationInfluence) {
        this.checkAndValidate(mvelExpression, resultCode, validationInfluence, null, null, null);
    }

    private void validate(String mvelExpression, ResultCode resultCode, int validationInfluence, String defaultMessage) {
        this.checkAndValidate(mvelExpression, resultCode, validationInfluence, null, defaultMessage, null);
    }

    private void validate(String mvelExpression, ResultCode resultCode, int validationInfluence, String messageId, String defaultMessage) {
        this.checkAndValidate(mvelExpression, resultCode, validationInfluence, messageId, defaultMessage, null);
    }

    private void validate(String mvelExpression, ResultCode resultCode, int validationInfluence, String messageId, String defaultMessage, String label) {
        this.checkAndValidate(mvelExpression, resultCode, validationInfluence, messageId, defaultMessage, label);
    }

    private void checkAndValidate(String mvelExpression, ResultCode resultCode, int validationInfluence, String messageId, String defaultMessage, String label) {
        if (!this.validationSummary.hasFatalValidationErrors()) {
            this.validator.setMessageId(messageId);
            this.validator.setDefaultMessage(defaultMessage);
            if (label == null) {
                int propertyBoundaryStartIndex = -1;
                for (String boundary : MVEL_PROPERTY_BOUNDARY_START) {
                    propertyBoundaryStartIndex = mvelExpression.indexOf(boundary);
                    if (propertyBoundaryStartIndex <= -1) continue;
                    label = mvelExpression.substring(0, propertyBoundaryStartIndex);
                    break;
                }
                if (propertyBoundaryStartIndex == -1) {
                    label = mvelExpression;
                }
            }
            this.validator.setLabel(label);
            ExecutionResult[] validationResults = this.validator.validate(mvelExpression, resultCode, this.entity);
            if (validationInfluence == 100) {
                for (ExecutionResult result : validationResults) {
                    if (result.getSeverity().getCode() < Severity.ERROR.getCode()) continue;
                    result.setSeverity(Severity.FATAL);
                }
            }
            if (validationResults != null) {
                this.validationSummary.addResults(validationResults);
            }
        }
    }
}

